class Message:
    """Instance Attributes:
        author [non-empty str]: username of the author of the message. 
           No two authors can have the same username. 
        content [non-empty str]: content of this message
        likes [int >= 0]: number of likes the message has. Initially 0.
        dislikes [int >= 0]: number of dislikes the message has. Initially 0.
    """

    def __init__(self, a, c):
        """Creates a new Message with: 
            author a, content c, 0 likes and dislikes

        Preconditions (no need to enforce):
            a: non-empty str
            c: non-empty str
        """
        self.author = a
        self.content = c
        self.likes = 0
        self.dislikes = 0

    def calculate_score(self):
        """
        Returns the score of this message
        """
        return self.likes - (self.dislikes//2)

class Post(Message):
    """Class attributes:
        promo_count [int]: number of posts currently promoted, initially 0
        PROMO_MAX: the max number of posts that can be promoted, set to 10

    Instance attributes:
    Includes those of Message. And also:
      title [non-empty str]: title of this post
      comments [list of Messages]: comments on this post. Initially empty.
      is_promoted [bool]: Whether the post is promoted. Initially False. 
    """
    #BEGIN REMOVE
    PROMO_MAX = 10
    promo_count = 0
    #END REMOVE


    
    def __init__(self, a, c, t):
        """Creates a new Post with author a, title t, content c, 
           0 likes and dislikes, empty coments, is_promoted set to False.

        Preconditions (no need to enforce): 
            a: non-empty str 
            t: non-empty str 
            c: non-empty str
        """
        #BEGIN REMOVE
        super().__init__(a, c)
        self.title = t
        self.comments = []
        self.is_promoted = False
        #END REMOVE
        
    def calculate_score(self):
        """ Returns the score [int] of this post

        If the post is promoted, the score is doubled 
            Otherwise, the score is calculated the same as any other Message.
        """
        #BEGIN REMOVE
        message_score = super().calculate_score()
        if self.is_promoted:
            return message_score * 2
        else:
            return message_score
        #END REMOVE
        
    def is_controversial(self):
        """ Return: True if this post is controversial; otherwise, False. 

        A post is considered controversial if the number of comments is greater 
        than the Post's score.
        """
        #BEGIN REMOVE
        
        return len(self.comments) > self.calculate_score()
        #END REMOVE
    

    def promote(self):
        """ 
        Promotes this post (incrementing the number of promoted posts appropriately)

        Returns True if the promotion was successful, otherwise False

        A promotion cannot be performed if: 
            1) the post is already promoted
            2) the post is controversial or
            3) The total number of promoted posts would be greater than PROMO_MAX
        """
        #BEGIN REMOVE
        if self.is_promoted or self.is_controversial() or \
          Post.promo_count >= Post.PROMO_MAX:
            return False
        else:
            Post.promo_count += 1
            self.is_promoted = True
            return True
        #END REMOVE



#BEGIN REMOVE

def try_promotion(p):
    success = p1.promote()
    if success:
        print("a promotion was successful")
    else:
        print("promotion could not be applied")

m1 = Message("tito", "love this")
p1 = Post("snoopy", "i like peanuts", "confession")
p1.likes = 10
p1.dislikes = 3
for n in range(10):
    p1.comments.append(m1)
score = p1.calculate_score()
print("this post has a score of "+str(score))
try_promotion(p1)
print("clear comments")
p1.comments = []
try_promotion(p1)
score = p1.calculate_score()
print("this post has a score of "+str(score))
#END REMOVE
