def send_help(s):
    """
    s is a string of one or more non-empty sequences of dashes and dots 
    separated by single exclamation points. Each sequence represents a 
    letter in Morse Code (A= '.-', B= '-...', O= '---', S= '...')

    Using this exclamation point encoding, the sign for needing help 
    (usually SOS: ...---... ) would be !...!---!...!

    We want to send help even if the SOS signal is 'hidden' among 
    other sequences in s.

    Returns True if the sequences for SOS appear in that order even
    if other sequences are present. Otherwise return False.

    Examples:
    send_help('!...!---!...!')           returns True
    send_help('!.!...!.-!---!.!...!')    returns True
    send_help('!...!...!---!')           returns False (wrong order)
    send_help('!....!...!---!')          returns False ('....' is H) 
    send_help('!...!...!.---!')          returns False ('.---' is J)
    """
    # BEGIN REMOVE
    if s.count("!...!") < 2 or s.count("!---!") < 1:
        return False
    i = s.find("!...!")
    i = s.find("!---!",i+1) #+1 is not specific but works
    if i == -1:
        return False
    i = s.find("!...!")
    if i == -1:
        return False
    return True
    
    # END REMOVE

# BEGIN REMOVE
if __name__ == '__main__':
     
     testcases = [['!...!---!...!', True],
                  ['!.!...!.-!---!.!...!', True],
                  ['!...!---!---!...!', True],
                  ['!---!...!---!...!', True],
                  ['!---!...!...!', False],
                  ['!...!...!---!', False],
                  ['!....!...!---!', False],
                  ['!...!...!---!...!', True],
                  ['!...!...!---.!', False]]
     
     for t in testcases:
          s = t[0]
          expected = t[1]
          print("Testing send_help("+repr(s)+")")
          result = send_help(s)
          assert result == expected, \
            "should have returned "+repr(expected)+" but got "+repr(result)

     print("Tests ran without crashing; the implementation seems OK!")
# END REMOVE
