def delete_morse(s, target):
    """ 
    s is a string of one or more non-empty sequences of dashes and dots 
    separated by single exclamation points.  Call these sequences "codes".

    Returns a version of s where the first occurrence of `target` as a code
    is removed. Otherwise returns the string 'NF' if `target` is not a code in s

    Examples:
    delete_morse('!.!.-!', '.-')       returns '!.!'
    delete_morse('!.!.-!', '.')        returns '!.-!'    
    delete_morse('!.!.-!..!.-!', '.-') returns '!.!..!.-!'
    delete_morse('!.-!', '.-')         returns '!!'
    delete_morse('!.!.-.!', '.-')      returns 'NF' even though '.-' is in s
    delete_morse('!.!..-!', '.-')      returns 'NF' even though '.-' is in s

    Preconditions on target: a non-empty string of dots and dashes 
    """
    # You may NOT use string method replace().
    # Take special care with the 4th example.
    # Hint: to handle the final 2 examples (where target, '.-', is a part of a 
    # code but not a complete match), notice one could look for '!.-!'
    # BEGIN REMOVE
    target_code = '!'+target+'!'

    if target_code not in s:
        return "NF"

    if s == target_code:
        return '!!'
    
    pos = s.index(target_code)

    # Solution explicitly checking that slicing uses valid indices 
    if pos+len(target_code) == len(s): 
        # target_code was at the end of s
        return s[:pos]+'!'  # Could also do s[:pos+1]
    else:
        # there is a code after target_code
        return s[:pos] + '!' + s[pos+len(target_code):]

    # Alternate solution to the if/else block: never involves an invalid index.
    # Leaves the '!' ending target_code in.
    return s[:pos] + s[pos+len(target_code) - 1:] 

    # Alternate solution to if/else block: depends on fact that s[x:y] is '' 
    # when x is  an illegal index.  
    # Notice that the first solution can be collapsed to this one ... in Python.
    return s[:pos] + '!' + s[pos+len(target_code):]   


    # Complete alternate solution using split(), inspired by code from Gary Ho 
    codes = s.split('!')[1:-1] # Slice removes empty strings from codes
    if target not in codes:
        return 'NF'

    # This is needed, to prevent returning '!' instead of '!!' for 4th example.
    if codes == [target]:
        return '!!'

    out = '!'
    first_found = False
    for code in codes:
        if code != target or first_found:
            out += code + '!'
        else:
            first_found = True
            # do NOT append code to out
    return out




    # END REMOVE

# BEGIN REMOVE
if __name__ == '__main__':
     
     testcases = [['!.!.-!', '.-', '!.!'],
                  ['!.!.-!', '.', '!.-!'],
                  ['!.-!.!', '.', '!.-!'],
                  ['!.!.-!..!.-!', '.-', '!.!..!.-!'],
                  ['!.-!', '.-', '!!'],
                  ['!.!.-.!', '.-', 'NF'],
                  ['!.!..-!', '.-', 'NF'],
                  
                  ]

     for t in testcases:
          s = t[0]
          target = t[1]
          expected = t[2]
          print("Testing delete_morse("+repr(s)+", "+repr(target)+")")
          result = delete_morse(s, target)
          assert result == expected, \
            "should have returned "+repr(expected)+" but got "+repr(result)

     print("Tests ran without crashing; the implementation seems OK!")
# END REMOVE
