def extract_maxes(values):
    """
    values: a non-empty list of non-empty lists of ints >= 0
       (no need to enforce these preconditions)

    Modifies `values` as follows:
       Removes the largest value from each list of ints in `values`.
       If there is a tie (2-way or more), removes the last occurrence 
          of the largest value in that list and ignores the earlier occurrences

    Return: a list containing the removed entries in their original order

    Ex: values = [ [4, 0, 12], [20], [4, 1, 2] ]
    Modified values = [ [4, 0], [], [1, 2] ]
    Returns [12, 20, 4]

    Ex: values = [ [12, 40, 16, 8], [30, 21, 30, 24] ]
    Modified values = [ [12, 16, 8], [30, 21, 24] ]
    Returns [40, 30]
    """
    # You may NOT use the built-in max() function.
    # BEGIN REMOVE
    removed = []
    for int_list in values:
        max_val = 0  # begin with smallest, positive value
        max_loc = -1 # 0 is not associated with an actual value in list
        for i in range(len(int_list)): 
            if int_list[i] >= max_val: #  > (strictly greater than) is wrong.
                max_val = int_list[i]
                max_loc = i
        removed.append(max_val)
        int_list.pop(max_loc) # could also use del
    return removed

    # END REMOVE


# BEGIN REMOVE
if __name__ == '__main__':

    li1 = [ [4, 0, 12], [20], [4, 1, 2] ]
    li2 = [ [12, 40, 16, 8], [30, 21, 30, 24] ]
    li3 = [ [40, 12, 40, 16, 8, 40], [30, 21, 30, 24], [3, 4, 6] ]
    testtriplets = [[li1, [12, 20, 4], [ [4, 0], [], [1, 2] ]],
                    [li2, [40, 30], [ [12, 16, 8], [30, 21, 24] ]],
                    [li3, [40, 30, 6], [ [40, 12, 40, 16, 8], [30, 21, 24], [3,4]]]
                    ]

    for item in testtriplets:
        values = item[0]
        expected_return = item[1]
        expected_modified = item[2]

        print(str(values)+": ")
        result = extract_maxes(values)
        print("\t"+str(values) + " & "+str(result)) 
        assert result == expected_return, \
        "Bad return result on list " + str(values) + ": " + str(result)
        assert values == expected_modified, \
        "Bad modified result on list " + str(values) + ": " + str(expected_modified)
    print("Tests ran without crashing")

# END REMOVE

