class Person:
    """ Objects represent an individuals in a social network.

    Attributes:
        name [str]: name of this person 
        following [list of persons]: list of persons this person follows
        fact_checker [boolean]: True if this person always fact checks
           their news before sharing. Otherwise, false.

    Assume no two people share the same name, 
    and no person can reach themselves through the following network.  """

    def __init__(self, n, following, fc):
        """ Creates a new person with name n, following attribute set to following, 
        and fact_checker attribute set to fc"""
        self.name = n
        self.following = following
        self.fact_checker = fc

def find_spreaders(root):
    """ Returns a (possibly empty) list of names of persons in root's network 
        (including root) who don't fact-check news. (They spread fake news.) 

        Example: 
           a = Person("Alice", [], True)
           b = Person("Bob", [], False)
           c = Person("Caitlin", [a, b], False)

           find_spreaders(a)   returns []
           find_spreaders(b)   returns ["Bob"]
           find_spreaders(c)   returns ["Caitlin", "Bob"]

    Precondition (no need to assert): root is a Person """

    # Note: the original question said to return a "list of persons" instead of
    # a "list of the names of persons". Credit was given for returning a
    # list of persons OR a list of person's names


    # BEGIN REMOVE
    spreaders = []
    if not root.fact_checker:
        spreaders.append(root.name)
    for f in root.following: # if root.following is [] the loop is never entered
        more = find_spreaders(f)
        for m in more:  # can replace for-loop with spreaders += more
            spreaders.append(m)
    return spreaders

    # Alternate solution (treats root.following == [] as a special case)

    if root.following == []:
        if root.fact_checker:
            return []
        else:
            return [root.name]

    spreaders = []
    if not root.fact_checker:
        spreaders.append(root.name)
    for f in root.following:
        spreaders += find_spreaders(f)
    return spreaders



    
    # END REMOVE





















# BEGIN REMOVE
if __name__ == '__main__':

    a = Person("Alice", [], True)
    b = Person("Bob", [], False)
    c = Person("Caitlin", [a, b], False)

    d = Person("Dorris", [], True)

    e = Person("Erich", [], False)

    f = Person("Frank", [e,d,c], False)
    
    testcases = [[c, ["Caitlin", "Bob"]],
                 [d, []],
                 [e, ["Erich"]],
                 [f, ["Frank", "Erich", "Caitlin", "Bob"]]
                 ]

    for item in testcases:
        p = item[0]
        expected = item[1]

        result = find_spreaders(p)
        print(p.name + ": "+str(result)) 
        assert result == expected, \
        "Bad result on person " + p.name + ": " + str(result)
    print("Tests ran without crashing")

# END REMOVE
