class School:
    """Instance attributes:
         fish_type [non-empty str]: type of the fish (e.g., "angelfish")
         count [int >= 0 ]: number of fish in this school
    """
    def __init__(self, name, count):
        self.name = name
        self.count = count

class FishTank:
    """Instance attributes:
	  my_fish [School]: the school that lives in this fish tank
             a fish tank can contain only one school at a time
          CAPACITY [int >= 0]: max number of fish that can fit in the tank
             Once initialized, this value should not change.
    """
    def __init__(self, a_school, capacity):
        self.my_fish = a_school
        self.CAPACITY = capacity
        
    def migrate(self, tank2, n):
        """Move n fish from self to tank2. 
           (counts of both schools should change accordingly)

        Preconditions (no need to assert): 
         - the two tanks have the same fish_type
         - tank2 is a FishTank
         - n is a positive int

        Move n fish, but also only as many fish as the donor school can offer 
        (based on its count) and also only as many as the receiving tank can accept 
        (based on the count of its current school and capacity of the tank).
        """
        #BEGIN REMOVE
        room_in_tank2 = tank2.CAPACITY - tank2.my_fish.count
        if room_in_tank2 < n:
            n = room_in_tank2 # migrate only the amount we have space for
        if self.my_fish.count < n:
            n = self.my_fish.count # migrate only the num fish we have to give

        # Alternate to the code block above:
        # min(n, self.my_fish.count, tank2.CAPACITY - tank2.my_fish.count)

        self.my_fish.count -= n
        tank2.my_fish.count += n
        #END REMOVE
        








#BEGIN REMOVE        
def test_tank():
    print("Testing tank")
    p1 = School("angelfish", 1) 
    p2 = School("angelfish", 3)
    p2 = School("angelfish", 3)
    b1 = FishTank(p1, 20)
    b2 = FishTank(p2, 10)

    print("tank 1 pre migration: fish count = "+str(b1.my_fish.count))
    print("tank 2 pre migration: fish count = "+str(b2.my_fish.count))
    print("move 7 from 1 to 2; more fish than are in self")
    b1.migrate(b2,7)
    assert b2.my_fish.count == 4 # only 1 fish to move
    assert b1.my_fish.count == 0

    print("\nmove 3 from 2 to 1")
    b2.migrate(b1,3)
    assert b2.my_fish.count == 1
    assert b1.my_fish.count == 3
    print()

    print("Testing capacity issues")
    b4 = FishTank(School("angelfish", 3), 3)
    print("tank 1 pre migration: fish count = "+str(b1.my_fish.count)) 
    print("tank 4 pre migration: fish count = "+str(b4.my_fish.count))   
    print("try to move 1 from 1 to 4 (which has capacity 3)")
    b1.migrate(b4, 1)
    assert b4.my_fish.count == 3, "should be 3 fish in 4 but there are "+str(b4.my_fish.count)



if __name__ == '__main__':
    test_tank()
#END REMOVE
