# Fall 2021 Q5
# Question by Fall 2021 course staff (minor edits by spring 2022 course staff)

def insert(nums, x):
    """Returns a copy of `nums`,  but where x has been inserted into the correct, 
    position in `nums`. (If the value `x` already occurs in `nums`, the
    returned list will have one more `x` in it.)

    Examples: 
    insert([0,2,4,5],3) returns [0,2,3,4,5] 
    insert([1,2,3,7],-1) returns [-1,1,2,3,7] 
    insert([1,2,2,7],2) returns [1,2,2,2,7]
    insert([],4) returns [4]

    Precondition: nums is a sorted (possibly empty) list of ints; x is an int"""
    # This exam question REQUIRED a recursive implementation and BARRED list
    # methods.

    if nums == []:
        return [x]

    # if nums is non-empty
    if x <= nums[0]:
        return [x]+nums
    else:
        return [nums[0]] + insert(nums[1:], x)


# TESTING CODE

testcases = [
    [[0,2,4,5], # nums
      3, # x
      [0,2,3,4,5] # expected
    ],
    [[1,2,3,7],
     -1,
     [-1,1,2,3,7]
    ],
    [[1,2,2,7],
     2,
     [1,2,2,2,7]
    ],
    [[],
     4,
     [4]
    ]
]

# Note: Spring 2022 disallowed students using simultaneous assignment to
# multiple variables (in part because other languages don't have it),  
# but in your "real programming lives", in Python this is
# a handy feature:
for [nums, x, expected] in testcases:
    print("Testing with nums="+repr(nums)+" and x="+repr(x))
    result = insert(nums, x)
    assert_msg = "result should be "+repr(expected)+" but is "+repr(result)
    assert result == expected, assert_msg


print("Ran through testcases without crashing! Great job --- but...")
print("YOU must verify yourself whether you obeyed the conditions of the question.")