def merge_records(d1, d2):
    """Input: d1 and d2 are two (possibly empty) dictionaries representing
    win-loss records:
        Each key is a non-empty string representing a team name
        The value for each key is a two-item list of ints, where the first is
            the number of wins and the second is the number of losses for that
            team in some tournament/outcome tree.

    This function adds the win-loss record of d2 into d1.

    Warnings: It does NOT return anything;
    It changes d1 but not d2.
    And, the values in the altered d1 should be different list objects than the
    list objects that are values in d2, even if they have the same numbers in
    them.

    For example:

    if d1 is                and d2 is               then d1 becomes
      {"Cornell": [10,1],      {"Cornell": [2,0],      {"Cornell":[12,1],
        "Harvard": [4,3]}        "Stanford": [0,3]}     "Harvard": [4,3],
                                                         "Stanford": [0,3]}

             where the new d1's "Stanford" list [0,3] is a DIFFERENT list object
             than d2's "Stanford" list object """

    # HINT: for a list mylist, list(mylist) or mylist[:] return a copy of mylist.


# BEGIN REMOVE

    for team in d2:
        if team in d1:
            d1[team][0] += d2[team][0]
            d1[team][1] += d2[team][1]
        else:
            d1[team] = list(d2[team])  # d2[team][:] also OK


def merge_records2(d1, d2):
    """Alternate implementation of above"""
    for team in d2:
        if team not in d1: # "if not team in d1" also OK
            # make it so team *is* in d1
            d1[team] = [0,0]

        d1[team][0] += d2[team][0]
        d1[team][1] += d2[team][1]



def merge_records3(d1, d2):
    """Alternate implementation of above"""

    for team in d1:
        if team in d2:
            d1[team][0] += d2[team][0]
            d1[team][1] += d2[team][1]

    for team in d2:
        if team not in d1:
            d1[team] = list(d2[team])



if __name__ == '__main__':
    d1 = {"Cornell": [10,1],"Harvard": [4,3]}
    d2 = {"Cornell": [2,0], "Stanford": [0,3]}


    for fn in [merge_records, merge_records2, merge_records3]:
        print "testing ", fn.__name__
        d1 = {"Cornell": [10,1],"Harvard": [4,3]}
        d2 = {"Cornell": [2,0], "Stanford": [0,3]}
        x = fn(d1, d2)
        assert x is None, fn.__name__ + "should not return anything"
        assert len(d1) == 3, "d1 is wrong: " + str(d1)
        assert d1["Cornell"] == [12, 1]
        assert d1["Harvard"] == [4, 3]
        assert d1["Stanford"] == [0,3]
        assert d1["Stanford"] is not d2["Stanford"]

        d3 = {}
        fn(d3, d2)
        d2["Stanford"] = [6,7]
        assert d3["Stanford"] == [0,3]   # d3 should not have changed



# END REMOVE