#stringlistsort.py
#Alex Parkhurst (anp56)
#5/16/17

def swap(b,h,k):
    """ Swaps element h and k in list b """
    tmp = b[h]
    b[h] = b[k]
    b[k] = tmp


def string_list_sort(b,h,k):
    """Swaps items in the PORTION of list b from index h up to and including
    index k so that strings are in front and lists are in back.
    Returns: index i such that b[h..i] are strings and b[i+1..k] are lists.

    Example: if b = [['Prospero', 'and', 'Ariel'], 'how', ['are', 'you']]
    string_list_sort(b,0,2) returns 0,
      and could change b to :
      ['how', ['are', 'you'], ['Prospero', 'and', 'Ariel']]
      or
      ['how', ['Prospero', 'and', 'Ariel'], ['are', 'you']]

    Your solution MUST use a while loop, MUST NOT create a copy of the list,
    and MUST satisfy the invariants set out in the code below.

    Precondition: b is a nonempty list containing only lists and strings; h and k
    are integers that are valid indices in list b"""
    # INVARIANT: b[h..i] are strings, b[t..k] are lists
    # PRECONDITION: no strings or lists yet identified (b[h..i] and b[t..k] both empty)

    # FIRST, FIX THESE INITIALIZATIONS
    i = None
    t = None

    # Hint: you may use the swap function from the previous page












    # BEGIN REMOVE
    i = h - 1
    t = k + 1
    while t != i+1:     # i < t-1 also OK
        if type(b[i+1]) == str:
            i = i + 1
        else: # type(b[i+1]) == list
            swap(b,i+1,t-1)
            t = t - 1
    # END REMOVE
    return i
    #POSTCONDITION: b[h..i] are strings, b[i+1..k] are lists

# BEGIN REMOVE

def s2(b,h,k):
    i = h - 1
    t = k + 1
    while t != i+1: # i < t-1, t >= i also OK
        if type(b[t-1]) == list: #isinstance also good here
            t = t - 1
        else: # type(b[t-1]) == str
            swap(b,i+1,t-1)
            #may also use python b[i+1],b[t-1] = b[t-1],b[j-1]
            i = i + 1
    return i



for fn in [string_list_sort, s2]:
    print "testing " + fn.__name__


    b = [['Prospero', 'and', 'Ariel'], 'how', ['are', 'you']]
    print 'start with', b
    print "index returned is " + str(fn(b,0,2))
    print "modified list is: "
    print b
    print


    b = [['bob', 'and', 'jim'], 'how', 'are', ['you', 'doing'], 'today']
    print 'start with', b
    print "index returned is " + str(fn(b,0,3))
    print "modified list is: "
    print b
    print

    print 'start with', b
    print "index returned is " + str(fn(b,0,4))
    print "modified list is: "
    print b
    print

    b = [[2],[3],[4]]
    print 'start with', b
    print "index returned is " + str(fn(b,0,2))
    print "modified list is: "
    print b
    print

    b = ['A', 'B', 'C', 'D']
    print 'start with', b
    print "index returned is " + str(fn(b,0,3))
    print "modified list is: "
    print b
# END REMOVE