# BEGIN REMOVE
# printSideBySide solution.
# Erik Anderson (ela63) and Alex Parkhurst (anp56) and Lillian Lee (LJL2)
# May 15, 2017
# END REMOVE
def putSideBySide(two_line_strings):
    """Returns: a string with two lines. The first line of the return string
        should contain, in order, the first line of each string in two_line_strings,
        separated by a space. The second line of the return string should contain,
        in order, the second line of each string in two_line_strings, separated by a space.

        Input: two_line_strings, which is a non-empty list of two-line strings.
        Each string has exactly this form: xx\nxx, where x is a character
        in [a..z or A..Z or 0..9]. There will always be exactly two characters
        before and after the new line character \n.

        Remember that \n is a SINGLE special character indicating a new line
        (which causes the string to print over multiple lines).

        For example:
        putSideBySide(["AB\nCD", "EF\nGH"]) should return "AB EF\nCD GH".

        This corresponds to arranging strings that print as:

        AB
        CD

        and:

        EF
        GH

        into the following:

        AB EF
        CD GH

        Note: should NOT add a space before the first string or after the last string.
        This would be wrong because there is a space before the first AB\nCD:

         AB EF
         CD GH

        Another example:
        putSideBySide(["AB\nCD", "EF\nGH", "IJ\nKL"]) returns "AB EF IJ\nCD GH KL".
    """
# BEGIN REMOVE
    line1 = ""
    line2 = ""
    first = True
    for a_string in two_line_strings:
        parts = a_string.split("\n")
        if first:
            first = False
        else:
            line1 += " "
            line2 += " "
        line1 += parts[0]
        line2 += parts[1]
    return line1 + "\n" + line2

def solAP1(two_line_strings):
    top_str = ''
    bottom_str = ''
    for x in two_line_strings:
        top_str += x[0:2] + ' '
        bottom_str += x[3:5] + ' '
    return top_str[:-1] + '\n' + bottom_str[:-1]

def solAP2(two_line_strings):
    top_str = two_line_strings[0][0:2]
    bottom_str = two_line_strings[0][3:5]
    for x in two_line_strings[1:]:
        top_str += ' ' + x[0:2]
        bottom_str += ' ' + x[3:5]
    return top_str + '\n' + bottom_str

def solAP3(two_line_strings):
    # ima hacky haxor solution.  Uses [::], which wasn't discussed in class
    twolist = '\n'.join(two_line_strings).split('\n')
    first = twolist[::2] #crazy python nonsense
    second = twolist[1:][::2]
    return ' '.join(first) + '\n' + ' '.join(second)



def solLL2(two_line_strings):
    converted = list(map(splitem, two_line_strings))

    # top is output[0], bottom is output[1]
    output = [converted[0][0], converted[0][1]]

    for i in range(1, len(converted)):
        for j in range(2):
            output[j] += (" " + converted[i][j])
    return output[0] + "\n" + output[1]


# helper for solLL2; to allow use of map
def splitem(tls):
    """Version of split() that takes the string to split as an argument"""
    return tls.split()


def solLL1(two_line_strings):
    top = ""
    bottom =""
    for tls in two_line_strings:
        nindex = tls.find("\n")
        front = tls[:nindex]
        back = tls[nindex+1:]
        top += (front + " ")
        bottom += ( back + " ")
    return top.strip() + "\n" + bottom.strip()





if __name__ == '__main__':
    for fn in [putSideBySide, solAP1, solAP2, solAP3, solLL1, solLL2]:
        print('Testing', fn.__name__)
        output = fn(["AB\nCD", "EF\nGH", "IJ\nKL"])
        assert output == "AB EF IJ\nCD GH KL", "bad output:" + str(output)+":"
    print('all tests passed')



# END REMOVE