def has_progression(x, step, n):
    """Returns:

    the first index 'start' in x where, for each j in the range 1..n,
    x[start+j] == x[start] + j*step. We say that n is the length of the progression.

    Returns -1 if there is no such start index.

    Examples: suppose x is [1,  2, 14, 16, 18, 20, 22]

    has_progression(x, 2, 3) -->  2 b/c x[2]==14, x[3]==16, x[4]==18, x[5]==20
    has_progression(x, 2, 4) -->  2 b/c 14, 16, 18, 20, 22 starts at x[2]
    has_progression(x, 2, 5) --> -1
    has_progression(x, 1, 1) --> 0

    Preconditions: x is a list of at least n+1 ints. step and n are ints, n >=1.
    """
    # USE THIS INITIALIZATION
    m = 0; start = 0
    i = 1 # there can't be length >= 1 progression in x[0..0]

    # Invariant: m is the length of the step-progression we are currently in;
    # start is the beginning of the length-m progression we are in, or i-1 if m==0;
    # and there is no step-progression of length n in x[0..i-1]

# BEGIN REMOVE





    while m < n and i < len(x):
        if x[i] - step == x[i-1]:   #or x[i] == x[i-1] + step
            m+= 1
        else:
            m = 0
            start = i # will be i-1 when i is updated
        i+= 1

    if m == n:
        return start
    else:
        return -1




def has_progression2(x, step, n):
    """Alternate implementation of has_progression"""

    # USE THIS INITIALIZATION
    m = 0; start = 0
    i = 1 # there can't be length >= 1 progression in x[0..0]

    # Invariant: m is the length of the step-progression we are currently in.
    # start is the beginning of the length-m progression we are in
    #        (start is i-1 if m==0)
    # There is no step-progression of length n in x[0..i-1]
    while m < n and i < len(x):
        if x[i] - step == x[i-1]:
            m+=1
            i+=1
        else:
            m=0
            i+=1
            start = i-1

    if m == n:
        return start
    else:
        return -1






if __name__ == '__main__':
    x = (1, 2, 14, 16, 18, 20, 22)
    test_cases = {
        (x, 1, 1): 0,
        (x, 1, 2): -1,
        (x, 2, 3): 2,
        (x, 2, 4): 2,
        (x, 2, 5): -1,
        ((-4, -8, 0, -5, -9, -13), -4, 2): 3,
        ((1,2,3,4,5,6), 1, 5):0
    }

    for fn in [has_progression, has_progression2]:
        print 'Testing', fn.__name__
        for tc in test_cases:
            thelist = list(tc[0]); step = tc[1]; n = tc[2]
            output = fn(thelist, step, n)
            e_msg = " on " + str(x) + " with step=" + str(step) + " n=" + str(n)
            e_msg += "\n The output was " + str(output)
            assert test_cases[tc] == output, "Problem with " + fn.__name__ + e_msg



# END REMOVE