# BEGIN REMOVE
import cornelltest as ct
from winloss_helper import merge_records


def standard_outcome():
    """Returns the sweet-16 Outcome depicted in Figure 1 of the CS1110 Spring
    2017 A4 handout, assuming a correct implementation of the Outcome __init__
    method in a4."""

    # You can compose calls to Outcome()
    east = Outcome(Outcome("Wisconsin", "Florida", False),
                   Outcome("Baylor", "South Carolina", False),
                   False)
    west = Outcome(Outcome("Gonzaga","West Virginia"),
                   Outcome("Xavier", "Arizona"))
    midwest = Outcome(Outcome("Kansas", "Purdue"),
                      Outcome("Oregon","Michigan"),
                      False)
    south = Outcome(Outcome("North Carolina", "Butler"),
                    Outcome("UCLA", "Kentucky", False))

    return Outcome(Outcome(east, west, False), Outcome(midwest, south, False), False)
def _extract_name(x):
    """Returns: string that is the "name" of x, defined as follows:
    If x is an Outcome, then the name is x's winner.
    If x is a string, then the name of x is x itself.

    Precondition: x is either a non-empty string or an Outcome."""




    if isinstance(x, Outcome):
        return x.winner
    else:
        # x must be a string, by precondition
        assert isinstance(x, str), "_extract_name: bad input x: " + str(x)
        return x
class Outcome(object):
    def __init__(self, in1, in2, one_won=True):
        self.input1 = in1
        self.input2 = in2
        if one_won:
            self.winner = _extract_name(in1)
        else:
            self.winner = _extract_name(in2)
    def __str__(self):
        output = self.winner + "\n"
        output += "\t" # start indenting for the sub-Outcomes
        s1 = str(self.input1) # A recursive call
        s1_lines = s1.splitlines(True)
        output += "\t".join(s1_lines)
        if isinstance(self.input1,str):
            output += "\n"
        output += "\t" + "\t".join(str(self.input2).splitlines(True))
        if isinstance(self.input2,str):
            output += "\n"
        return output
# END REMOVE

# BEGIN REMOVE
    def loutcomeVersion(self):
        """Return a new Loutcome that is equivalent to this Outcome.
        Does NOT change this Outcome"""
        if _extract_name(self.input1) == self.winner:
            one_won = True
        else:
            one_won = False

        if isinstance(self.input1, Outcome):
            in1 = self.input1.loutcomeVersion()
        else:
            in1 = self.input1 # it's a string

        # handle for input2
        if isinstance(self.input2,Outcome):
            in2 = self.input2.loutcomeVersion()
        else:
            in2 = self.input2

        return Loutcome(in1, in2, one_won) #@ need one_won

# END REMOVE


class Loutcome(Outcome):
    """Like an Outcome, except for an EXTRA attribute:

    loser [nonempty str]: name of the loser in this Outcome
    """

    def __init__(self, in1, in2, one_won=True):
        """Same as for the __init__ for Outcome, except that:

            If one_won is True, loser is the name of in2's winner
            (if in2 is an Loutcome) or in2 itself (if in2 is a string)

            Otherwise, loser is in1's winner (if in1 is an Loutcome) or
                in1 itself (if in1 is a string)

        Preconditions: same as for the __init__ for Outcome, except substitute
        the word "Loutcome" for "Outcome"  """

        # YOU MUST USE MAKE EFFECTIVE USE OF A CALL TO Outcome's __INIT__




        # BEGIN REMOVE
        Outcome.__init__(self, in1, in2, one_won)     # CAN'T say "one_won=True"
        if one_won:  # "if one_won == True" OK
            self.loser = _extract_name(in2)
        else:
            self.loser = _extract_name(in1)
        # END REMOVE





# BEGIN REMOVE
    def __str__(self):
        """Spec skipped for space/time"""
        output = self.winner + " beat " + self.loser + "\n"
        output += "\t" # start indenting for the sub-Outcomes
        s1 = str(self.input1) # A recursive call
        s1_lines = s1.splitlines(True)
        output += "\t".join(s1_lines)
        if isinstance(self.input1,str):
            output += "\n"
        output += "\t" + "\t".join(str(self.input2).splitlines(True))
        if isinstance(self.input2,str):
            output += "\n"
        return output

# END REMOVE

    def winsAndLosses(self, team):
        """Returns: a two-item list where the item at index 0 is the number of
           games that team won, and the item at index 1 is the number of games
           that team lost.

           Precondition: team [str] is a team that played in this Loutcome.
        """
        # BEGIN REMOVE
        if team == self.winner:
            output = [1, 0]
        elif team == self.loser:
            output = [0, 1]
        else:
            output = [0,0]

        for sub in [self.input1, self.input2]:
            if isinstance(sub, Loutcome):
                suboutput = sub.winsAndLosses(team)
                output[0] += suboutput[0]
                output[1] += suboutput[1]
        return output
        # END REMOVE



    def winsAndLosses1(self):
        """Returns: a dictionary where keys are teams and values are two-item
        lists where the item at index 0 is the number of games the team won, and
        the  item at index 1 is the number of games the team lost.

        Example: for the Loutcome below:    Here's what should be returned
        D beat B                                (order of keys unimportant)
            D beat A
                A beat B                    {"A": [1,1],
                    A                        "B": [1,2],
                    B                        "C": [0,2],
                D beat C                     "D": [3,0]}
                    C
                    D
            B beat C
                B
                C
        """



# BEGIN REMOVE

        d = {
            self.winner:[1,0],
            self.loser:[0,1]
        }

        if isinstance(self.input1, Loutcome):
            merge_records(d, self.input1.winsAndLosses1())
        if isinstance(self.input2, Loutcome):
            merge_records(d, self.input2.winsAndLosses1())

        return d


def winsAndLosses2(loutcome):
    d = {loutcome.winner:[1,0], loutcome.loser:[0,1]}

    if isinstance(loutcome.input1, Loutcome):
        merge_records(d, winsAndLosses2(loutcome.input1))
    if isinstance(loutcome.input2, Loutcome):
        merge_records(d, winsAndLosses2(loutcome.input2))

    return d



# END REMOVE






# BEGIN REMOVE
if __name__ == '__main__':



    winners = Loutcome(Loutcome("A", "B"),
                         Loutcome("C", "D", False),
                         False)
    losers_rematch = Loutcome("B", "C")
    multi = Loutcome(winners, losers_rematch, True)
    # print multi

    test_cases = {
        "A":[1,1],
        "B":[1,2],
        "C":[0,2],
        "D":[3,0],
    }
    output = multi.winsAndLosses1()
    ct.assert_equals(4, len(output))
    for t in test_cases:
#        print '\t testing ' + t
        ct.assert_equals(test_cases[t], output[t])

    print 'Testing simpler version'
    for t in test_cases:
        output = multi.winsAndLosses(t)
        ct.assert_equals(test_cases[t], output)

    # Test standard outcome
    standard = standard_outcome()
    standard_loutcome = standard.loutcomeVersion()
    #print standard_loutcome

    test_cases = {
        "Wisconsin":[0,1],
        "Florida":[1,1],
        "South Carolina":[2,1],
        "Gonzaga":[3,1],
        "North Carolina":[4,0],
        "Baylor":[0,1],
        "Butler":[0,1],
        "Kansas":[1,1],
        "Oregon":[2,1],
        "Xavier":[1,1],
        "West Virginia":[0,1],
        "Arizona": [0,1],
        "Purdue": [0,1],
        "Michigan":[0,1],
        "Kentucky":[1,1],
        "UCLA":[0,1]
    }

    print 'testing method version of winsAndLosses'
    output = standard_loutcome.winsAndLosses1()
    ct.assert_equals(16,len(output))
    for t in test_cases:
        #print '\t testing ' + t
        ct.assert_equals(test_cases[t], output[t])

    print 'testing non-method version of winsAndLosses'
    output = winsAndLosses2(standard_loutcome)
    ct.assert_equals(16,len(output))
    for t in test_cases:
        #print '\t testing ' + t
        ct.assert_equals(test_cases[t], output[t])

# END REMOVE


