# test_ll.py

import inspect  # For automatically getting function name

import for_loop1 as fl1
import for_loop2 as fl2
import collapse as coll

def show_was_is(tag1, val1, tag2, val2):
    """Return string for printing of two labeled values"""
    return tag1 + " was: " + str(val1) + '; ' + tag2 + " was " + str(val2)



def test_overlay_val(verbose):
    print("Running " + inspect.stack()[0][3])

    test_cases = {
        (('_', '_', '_'),
         ('m', 'o', 'o',),
         'o'):  ['_', 'o', 'o'],
        (('_', '_', '_'),
         ('m', 'o', 'o'),
         'e'): ['_', '_', '_'],
        (('x', 'x', 'x'),
         ('m', 'o', 'o'),
         'e'): ['x', 'x', 'x'],
        (('x', 'y', 'z'),
         ('m', 'o', 'o'),
         'e'): ['x', 'y', 'z'],
        ((0, 9, 4),
         (4, 0, 2),
         0): [0, 0, 4],
        ((False, 1, True),
         (4, False, 'h'),
         False): [False, False, True],
        ((), (), 5): []

    }

    for tc in test_cases:
        if verbose:
            print('Testing ' + str(tc))

        orig1 = list(tc[0]) # For checking against original inputs
        orig2 = list(tc[1])

        val = tc[2]
        answer = test_cases[tc]
        to_list = orig1[:]
        from_list = orig2[:]
        fl1.overlay_value(to_list, from_list, val)
        assert answer == to_list, show_was_is("answer", answer, "to_list", to_list)
        assert from_list == orig2, show_was_is("orig2", orig2, "from_list", from_list)


def test_counts(verbose):
    print("Running " + inspect.stack()[0][3])

    targets1 = [0, 12, -7, 13]
    test_list = [[4000, 1100, 3600, 1000],
                 [12, -10000],
                 [13, 0, 13],
                 []]
    test_answers = [0, 1, 3, 0]
    for test_fn in [fl2.counts]:
        result = test_fn(test_list, targets1)
        assert result == test_answers, show_was_is("result", result, "answer", test_answers)


def test_collapse(verbose):
    print("Running " + inspect.stack()[0][3])

    A = coll.Position("A", [], [])
    B = coll.Position("B", [A], [])
    D = coll.Position("D", [A], [])
    C1 = coll.Position("C1", [B], [])
    C2 = coll.Position("C2", [B], [])
    E = coll.Position("E", [], [C1])

    C1.become_sub_of(A)

    coll.draw(A, figtitle="before")
    B.collapse_upwards()
    coll.draw(A, figtitle="after")

    for p in [A, B, D, C1, C2, E]:
        print(p)
        print(p.sups)
        print(p.subs)


if __name__ == '__main__':
    # prompt = "Hit return if you want minimal output; "
    # prompt += "anything else will generate more verbose output: "
    # verbose = bool(input(prompt))

    verbose = True

    test_fns = [test_overlay_val, test_counts, test_collapse]

    for test_fn in test_fns:
        test_fn(verbose)
