class WishItem:
    """ An instance represents an item in a person's wish list at a shop

    Instance attributes:
        code [non-empty str]: unique string identifying the product wanted
        num_units [positive int]: number of units of the product wanted """

    def __init__(self, p_code, p_num):
        """Creates a new WishItem with attributes set as follows:
            code: set to `p_code`, where `p_code` is a non-empty string
            num_units: set to `p_num`, where `p_num` is a positive int """
        self.code= p_code
        self.num_units = p_num


def add_to_wish_list(wlist, prod, u):
    """ Modify `wlist`, a list of WishItems, by adding `u` units of the product
    with the product code `prod`.  If the product is already in the list, increase
    the number of units wanted for that product by `u`.  If the product is not in
    the list, update `wlist` to include a new WishItem with `u` units of that
    product.  This function modifies the list; it does not create a new list.

    Preconditions (no need to assert these):
        wlist: a list of WishItems or an empty list. The elements in wlist have
                distinct product codes.
        prod: a non-empty string identifying the product wanted
        u: the number of units of the product to be added, a positive int"""

    pass # STUDENTS: implement this

if __name__=='__main__':
    print("testing while-loop question")
    wlist= []
    add_to_wish_list(wlist, 'a0', 1)
    assert len(wlist)==1 and wlist[0].code=='a0' and wlist[0].num_units==1
    add_to_wish_list(wlist, 'a0', 2)
    assert len(wlist)==1 and wlist[0].code=='a0' and wlist[0].num_units==3
    add_to_wish_list(wlist, 'a1', 20)
    assert len(wlist)==2 and wlist[1].code=='a1' and wlist[1].num_units==20
    print("finished testing while-loop question")
