class Employee():
    """An instance represents an employee.

    Instance variables:
        name [str] - unique non-empty name of employee
        employees [list of Employee] - employees reporting directly to this employee.
           *** LENGTH IS AT MOST 2 ***. (The length can be 0.)
    """
    def __init__(self, name, employees):
        """Create new employee with name and employee list. """
        self.name = name
        self.employees = employees

def get_tree(person):
    """Returns list of names of ALL employees that are *underneath*
    `person` (at any level). Order of list items does not matter; duplicates OK.

    Example:
    engineer = Employee('E', [])      means get_tree(engineer) --> []
    cto = Employee('T', [engineer])   means get_tree(cto) --> ['E']
    coo = Employee('O', [])           means get_tree(coo) --> []
    ceo = Employee('CEO', [coo, cto]) means get_tree(cea) --> ['O','T','E']

    Precondition: `person` is an Employee."""
    pass


if __name__ == '__main__':
    print("testing function get_tree")
    engineer = Employee('E', [])
    cto = Employee('T', [engineer])
    coo = Employee('O', [])
    ceo = Employee('CEO', [coo, cto])

    testcases = [[engineer, []],
                [cto, ['E']],
                [coo, []],
                [ceo, ['O','T','E']]
                ]

    for item in testcases:
        obj = item[0]
        expected = set(item[1]) # use sets to ignore order

        result = set(get_tree(obj))
        assert result == expected, \
        "Bad result on " + obj.name + ": " + str(result)
    print("testing method get_tree finished")
