def date_of_birth(name, m, d, y):
    """
    Returns date of birth with month `m`, day `d` and year `y`
    of a person with name `name`.

    Examples:
        date_of_birth('Jiwon', 9, 13, 2000)
        --> "Jiwon was born on Sept. 13th, 2000!"

        date_of_birth('Rene Descartes', 3, 31, 1596)
        --> "Rene Descartes was born on Mar. 31st, 1596!"

    Preconditions:
        name: string.
        m: int. 1 <= m <= 12
        d: int. 1 <= d <= 31
        y: int. 1 <= y <= 2022
    """
    month = get_month(m)
    day = get_day(d)
    year = y

    date_of_birth = month + " " + day + ", " + year

    message = name + " was born on " + date_of_birth + "!"
    return message

def get_month(m):
    """Returns month name for month number `m`.
    The 1st month name is "Jan."
    """
    month_list = ["Jan.", "Feb.", "Mar.", "Apr.", "May",
    "June", "July", "Aug.", "Sept.", "Oct.", "Nov.", "Dec."]

    month = month_list[m]
    return month

def get_day(d):
    """
    Returns a string representation of day `d`
    with appropriate suffixes using the following rules:

    1. Days 11, 12, 13: use "th".
    2. Any other days ending in 1,2,3: use "st", "nd", and "rd", respectively.
    3. Any other remaining days: use "th".

    Examples:
        get_day(11) --> "11th"
        get_day(1) --> "1st"
        get_day(28) --> "28th"

    """
    ending = d % 10

    if d in [11, 12, 13]:
        day = day_th(d)
    elif ending <= 3:
        day = day_st_nd_rd(d)
    else:
        day = day_th(d)

    return day

def day_st_nd_rd(d):
    """
    precondition: d: int, where last digit
      is between 1 and 3 inclusive.
    """
    ending = d % 10

    if ending == 1:
        suffix = "st"
    elif ending == 2:
        suffix = "nd"
    else:
        suffix = "rd"

    day = str(d) + suffix
    return day

def day_th(d):
    day = str(d) + "th"
    return day

if __name__ == '__main__':
    exp = "Jiwon was born on Sept. 13th, 2000!"
    result = date_of_birth('Jiwon', 9, 13, 2000)
    assert  result == exp, \
       "expected '" + exp + "' but got '"+ repr(result) + "'"

    exp = 'Jason was born on Dec. 20th, 1988!'
    result = date_of_birth('Jason', 12, 20, 1988)
    assert  result == exp, \
       "expected '" + exp + "' but got '"+ repr(result) + "'"
