class Student:
    """Instance attributes:
        netid [non-empty str]: netID, unique to this Student
        opted_in [bool]: Whether this Student should be emailed announcements.
        courses [list of Courses]: Courses this Student is enrolled in.
            Can be empty.
        inbox [list of strings]: messages for this Student.  Can be empty."""
    def __init__(self, n, opted_in):
        self.netid = n
        self.opted_in = opted_in
        self.courses = []
        self.inbox = []

class Course:
    """Instance attributes:
        enrolled: List of unique Students enrolled in this Course.
                  Can be empty.
        announcements: possibly empty list of strings. """
    def __init__(self):
        self.enrolled = []
        self.announcements = []

    def announce(self, a):
        """Adds `a` to this Course's announcements.
        Also adds `a` to the end of the inbox of every Student enrolled in this
            Course that has opted in.
            (Does *not* do so for Students that did *not* opt in.)

        Returns: a list of the netids of the Students that had the announcement
            put in their inbox.

        Precondition: `a` is a nonempty string."""
        pass

def test_announce():
    print("Testing announc")
    s1 = Student("Alpha Opted-In", True)
    s2 = Student("Beta Opted Out", False)
    c = Course()
    c.enrolled = [s1, s2]
    s1.courses = [c]
    s2.courses = [c]
    emailed = c.announce("Semester over!")
    assert s1.inbox == ['Semester over!']
    assert s2.inbox == []
    assert c.announcements == ['Semester over!']
    assert emailed == ['Alpha Opted-In']
    print("finished testing announce")

if __name__ == '__main__':
    test_announce()
