"""
Unit test for the module flow..

This script has tests for two different functions in flow.  It demonstrates how to create
tests that ensure "code coverage" when a function includes if-statements.

In addition, if the print statements in flow.py are uncommented, this script can
demonstrate the value of trace statements.

Author: Walker M. White
Date:   September 10, 2019
"""
import introcs                      # introcs assert functions
import flow                         # functions to be tested


def test_max2():
    """
    Test procedure for max2(x,y)
    """
    print('Testing max2')

    # Test x < y
    result = flow.max2(1,2)
    introcs.assert_equals(2,result)

    # Test x > y
    result = flow.max2(3,2)
    introcs.assert_equals(3,result)

    # Test x == y
    result = flow.max2(0,0)
    introcs.assert_equals(0,result)


def test_max3():
    """
    Test procedure for max3(x,y,z)
    """
    print('Testing max3')

    # Test x < y < z
    result = flow.max3(1,2,3)
    introcs.assert_equals(3,result)

    # Test y < x < z
    result = flow.max3(3,2,4)
    introcs.assert_equals(4,result)

    # Test x < z < y
    result = flow.max3(1,3,2)
    introcs.assert_equals(3,result)

    # Test y < z < x
    result = flow.max3(3,1,2)
    introcs.assert_equals(3,result)

    # Test z < y < x
    result = flow.max3(4,3,2)
    introcs.assert_equals(4,result)

    # Test z < x < y
    result = flow.max3(2,3,1)
    introcs.assert_equals(3,result)

    # Test x == y < z
    result = flow.max3(1,1,2)
    introcs.assert_equals(2,result)

    # Test x == z < y
    result = flow.max3(2,3,2)
    introcs.assert_equals(3,result)

    # Test y == z < x
    result = flow.max3(4,3,3)
    introcs.assert_equals(4,result)

    # Test z < x == y
    result = flow.max3(3,3,1)
    introcs.assert_equals(3,result)

    # Test y < x == z
    result = flow.max3(4,2,4)
    introcs.assert_equals(4,result)

    # Test x < y == z
    result = flow.max3(1,2,2)
    introcs.assert_equals(2,result)

    # Test x == y == z
    result = flow.max3(0,0,0)
    introcs.assert_equals(0,result)


# Script code
if __name__ == '__main__':   # Guarantees only executes when run as script
    test_max2()
    test_max3()
    print('Module flow passed all tests.')
