"""
Unit test for the module name.

This script illustrates what a unit test should look like. It is testing a
single function in the module name, and therefore has a single test procedure.

It also has a segment of "script code" that invokes the test procedure when
this module is run as an script.

Author: Walker M. White
Date:   August 31, 2018
"""
import introcs                      # introcs assert functions
import name                         # function to be tested


def test_last_name_first():
    """
    Test procedure for last_name_first(n)
    """
    print('Testing last_name_first')

    # Test one space between names
    result = name.last_name_first('Walker White')
    introcs.assert_equals('White, Walker',result)

    # Test multiple spaces between names
    result = name.last_name_first('Walker     White')
    introcs.assert_equals('White, Walker',result)


# Script code
if __name__ == '__main__':   # Guarantees only executes when run as script
    test_last_name_first()
    print('Module name passed all tests.')
