"""
Trace statements illustrating control statment flow

Trace statements are just print statements that tell us
where we are in the code.  They are distinct from a
watch, which tells us the current contents of a variable.

Author: Walker M. White
Date:   September 10, 2019
"""


def max2(x,y):
    """
    Returns: max of x, y

    Shows of flow of if-else
    """
    # Put max of x, y in z
    #print('max('+str(x)+','+str(y)+')')     # WATCH(ES)
    #print('before if')                      # TRACE
    if x > y:
        #print('if x>y')                     # TRACE
        z  = x
        #print('z is '+str(z))               # WATCH
    else:
        #print('else x<=y')                  # TRACE
        z  = y
        #print('z is '+str(z))               # WATCH
    #print('after if')                       # TRACE
    return z


def max3(x,y,z):
    """
    Returns: max of x, y, z

    Shows of flow of if-elif-else
    """
    # Put max of x, y, z in w
    #print('max('+str(x)+','+str(y)+','+str(z)+')')
    #print('before if')                      # TRACE
    if x > y and x > z:
        #print('if x>y and x>z')             # TRACE
        w  = x
        #print('w is '+str(w))               # WATCH
    elif y > z:
        #print('elif y>z and y>=x')          # TRACE
        w  = y
        #print('w is '+str(w))               # WATCH
    else:
        #print('else z>=x and z>=y')         # TRACE
        w  = z
        #print('w is '+str(w))               # WATCH
    #print('after if')                       # TRACE
    return w
