"""
A unit test for palindrome functions.

Author: Walker M. White (wmw2)
Date:   October 10, 2018
"""
import introcs
import palindrome


def test_ispalindrome():
    """
    Tests the basic palindrome function
    """
    introcs.assert_equals(True,  palindrome.ispalindrome(''))
    introcs.assert_equals(True,  palindrome.ispalindrome('B'))
    introcs.assert_equals(True,  palindrome.ispalindrome('BB'))
    introcs.assert_equals(False, palindrome.ispalindrome('BA'))
    introcs.assert_equals(True,  palindrome.ispalindrome('BOB'))
    introcs.assert_equals(False, palindrome.ispalindrome('BOA'))
    introcs.assert_equals(True,
                              palindrome.ispalindrome('ablewasiereisawelba'))
    introcs.assert_equals(True,
                              palindrome.ispalindrome('amanaplanacanalpanama'))
    introcs.assert_equals(False,
                              palindrome.ispalindrome('Amanaplanacanalpanama'))
    introcs.assert_equals(False,
                              palindrome.ispalindrome('amanaplana canalpanama'))


def test_ispalindrome2():
    """
    Tests the palindrome function without case
    """
    introcs.assert_equals(True,  palindrome.ispalindrome2(''))
    introcs.assert_equals(True,  palindrome.ispalindrome2('B'))
    introcs.assert_equals(True,  palindrome.ispalindrome2('BB'))
    introcs.assert_equals(False, palindrome.ispalindrome2('BA'))
    introcs.assert_equals(True,  palindrome.ispalindrome2('BOB'))
    introcs.assert_equals(False, palindrome.ispalindrome2('BOA'))
    introcs.assert_equals(True,
                              palindrome.ispalindrome2('ablewasiereisawelba'))
    introcs.assert_equals(True,
                              palindrome.ispalindrome2('amanaplanacanalpanama'))
    introcs.assert_equals(True,
                              palindrome.ispalindrome2('Amanaplanacanalpanama'))
    introcs.assert_equals(False,
                              palindrome.ispalindrome2('amanaplana canalpanama'))


def test_ispalindrome_loosely():
    """
    Tests the palindrome without case, non-letters
    """
    introcs.assert_equals(True,
        palindrome.ispalindrome_loosely('a**68(&!#7! a'))
    introcs.assert_equals(True,
        palindrome.ispalindrome_loosely('A man, a plan, a canal --Panama!'))
    introcs.assert_equals(False,
        palindrome.ispalindrome_loosely('A man, a plan, a cabal --Panama!'))


# Script Code
if __name__ == '__main__':
    test_ispalindrome()
    test_ispalindrome2()
    test_ispalindrome_loosely()
    print('Module palindrome is working properly')
