"""
Module showing how to use range with loops

The last function -- add_one -- shows how to use ranges to create a mutable function.

Author: Walker M. White (wmw2)
Date:   October 2, 2019
"""


def isprime(n):
    """
    Returns: True if no integer in 2..n-1 divides n, else False
    
    Parameter n: the number to check
    Precondition: n > 1 an int
    """
    result = True
    
    for x in range(2,n):
        if n % x == 0:   # x "goes evenly" into n
            result = False
    
    return result


def sum_of_odd_squares(m, n):
    """
    Returns: sum of squares of odd integers in the range m..n.
    
    Parameter m: the start of the range
    Precondition: n >= m is an int
    
    Parameter n: the end of the range
    Precondition: m <= n is an int
    """
    total = 0
  
    for x in range(m,n):
        if x % 2 == 1:   # odd
            total = total + (x*x)
    
    return total


def add_one(thelist):
    """
    Adds 1 to every element in the list
    
    Parameter the list: the list to modify
    Precondition: thelist is a list of numbers (either floats or ints)
    """
    size = len(thelist)
    
    for k in range(size):
        thelist[k] = thelist[k]+1
    
    # procedure; no return

