"""
A simple module showing off for simple loops

All of these functions (except the first one) use the accumulator pattern.  For
examples of mutable functions, look at the file ranges.py

Author: Walker M. White (wmw2)
Date:   October 2, 2019
"""
import string


def simple_for(seq):
    """
    Prints out each element of the list seq
    
    Parameter seq: the sequence to print out
    Precondition: seq a sequence (string or list)
    """
    for x in seq:
        print('Current element is '+str(x))
        print('Still doing loops')
    print('Done with function')


def sum(thelist):
    """
    Returns: the sum of all elements in thelist
    
    Parameter the list: the list to sum
    Precondition: thelist is a list of numbers (either floats or ints)
    """
    result = 0
    
    for x in thelist:
        result = result+x
        print('Adding '+str(x)+' yields '+str(result))
    
    return result


def despace(s):
    """
    Returns: s but with its spaces removed
    
    Examples:
        despace('Hello World!') returns 'HelloWorld!'
        despace(' a b c d e ') returns 'abcde'
    
    Parameter s: the text to remove spaces
    Precondition: s is a string
    """
    # Accumulator
    result = ''
    
    for x in s:
        if x != ' ':
            result = result+x
    
    return result


def num_ints(thelist):
    """
    Returns: the number of ints in thelist
    
    Parameter thelist: the list to count
    Precondition: thelist is a list of any mix of types
    """
    result = 0
    
    for x in thelist:
        if type(x) == int:
            print(str(x)+' is an int')
            result = result+1
    
    return result


def copy_add_one(thelist):
    """
    Returns: copy with 1 added to every element
    
    Parameter the list: the list to copy
    Precondition: thelist is a list of numbers (either floats or ints)
    """
    mycopy = []  # accumulator
    
    for x in thelist:
        x = x+1
        mycopy.append(x)  # add to end of accumulator
    
    return mycopy


def num_digits(s):
    """
    Returns: number of chars in s that are digits
    
    Parameter s: the string to count
    Precondition: s a string
    """
    total = 0  # Holds the digit count
        
    for c in s:
        if c in string.digits:
            total = total + 1 # Increment if character is a digit
    
    return total


def no_blanks(s):
    """
    Returns: copy of s with no blanks
    
    Parameter s: the string to copy
    Precondition: s a string
    """
    result = '' # Holds the copy string
    
    for c in s:
        if not c in string.whitespace:
            result = result+c # glue it to the result
    
    return result
