"""
A test script to test our generators

Author: Walker M. White
Date: November 30, 2020
"""
import chain
import chunkify
import introcs


def test_sumfold():
    """
    Tests the generator sumfold
    """
    print('Testing sumfold')

    # FIRST TEST
    g = chain.sumfold(range(4))

    # Check each element generated
    result = next(g)
    introcs.assert_equals(0,result)

    result = next(g)
    introcs.assert_equals(1,result)

    result = next(g)
    introcs.assert_equals(3,result)

    result = next(g)
    introcs.assert_equals(6,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)

    # SECOND TEST
    g = chain.sumfold([-1,3,7,-5])

    # Check each element generated
    result = next(g)
    introcs.assert_equals(-1,result)

    result = next(g)
    introcs.assert_equals(2,result)

    result = next(g)
    introcs.assert_equals(9,result)

    result = next(g)
    introcs.assert_equals(4,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)


def test_filterdiv():
    """
    Tests the generator filterdiv
    """
    print('Testing filterdiv')

    # FIRST TEST
    g = chain.filterdiv(range(5),2)

    # Check each element generated
    result = next(g)
    introcs.assert_equals(0,result)

    result = next(g)
    introcs.assert_equals(2,result)

    result = next(g)
    introcs.assert_equals(4,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)

    # SECOND TEST
    g = chain.filterdiv(range(5),3)

    # Check each element generated
    result = next(g)
    introcs.assert_equals(0,result)

    result = next(g)
    introcs.assert_equals(3,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)

    # THIRD TEST
    g = chain.filterdiv([5,-1,3,10,-5],5)

    # Check each element generated
    result = next(g)
    introcs.assert_equals(5,result)

    result = next(g)
    introcs.assert_equals(10,result)

    result = next(g)
    introcs.assert_equals(-5,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)


def test_chunkify():
    """
    Tests the coroutine chunkify
    """
    print('Testing chunkify')

    # FIRST TEST
    g = chunkify.chunkify(range(5))

    # This should not return a value
    result = next(g)
    introcs.assert_equals(None,result)

    # Check each element generated
    result = g.send(2)
    introcs.assert_equals([0,1],result)

    result = g.send(3)
    introcs.assert_equals([2,3,4],result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)

    # SECOND TEST
    g = chunkify.chunkify(range(8))

    # This should not return a value
    result = next(g)
    introcs.assert_equals(None,result)

    # Check each element generated
    result = g.send(2)
    introcs.assert_equals([0,1],result)

    result = g.send(3)
    introcs.assert_equals([2,3,4],result)

    result = g.send(2)
    introcs.assert_equals([5,6],result)

    result = g.send(2)
    introcs.assert_equals([7],result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)

    # THIRD TEST
    g = chunkify.chunkify([])

    # This should not return a value
    result = next(g)
    introcs.assert_equals(None,result)

    # Check each element generated
    result = g.send(2)
    introcs.assert_equals([],result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)


# Script Code
if __name__ == '__main__':
    test_sumfold()
    #test_filterdiv()
    #test_chunkify()
    print('The generators passed all tests')
