"""
A simple coroutine to demonstrate the back-and-forth

Author: Walker M. White
Date:   December 3, 2020
"""


def pushsum(n):
    """
    A coroutine that yields the sum of all numbers pushed to it
    
    Parameter n: The maximum number of numbers to push
    Precondition: n is an int > 0
    """
    sum = 0
    for x in range(n):
        value = (yield sum)
        sum = sum+value
    yield sum


def sumfold(lst):
    """
    Returns a list where each element is the sum of lst so far
    
    Example: sumfold([1,3,-4,2]) returns [1,4,0,2]
    
    Parameter lst: The list to process
    Precondition: lst is a list of numbers
    """
    sum = []
    g = pushsum(len(lst))
    next(g)
    for x in lst:
        a = g.send(x)
        sum.append(a)
    return sum

