"""
A coroutine to process a list in chunks.

This module has a coroutine and a normal function in it.  The normal function is the
parent (or sometimes called the "driver") of the coroutine, ensuring that it always
makes forward progress.

Author: Walker M. White
Date:   December 3, 2020
"""

def chunkify(input):
    """
    Coroutine to break a input into list chunks.

    Each call to send is the number of elements to chunk. At each call, it yields a
    new list of the size of the number of elements in send.

    If the size sent is not an int or is <= 0, it yields the empty list

    Parameter input: The data to process
    Precondition: input is an LIST
    """
    pass # IMPLEMENT ME

    size = (yield) # HOW MANY ELEMENTS TO OUTPUT
    result = []
    for x in input:
        result.append(x)
        size = size - 1
        if size == 0:
            size = (yield result)
            result = []

    if len(result) != 0:
        yield result


def printit(lst,step):
    """
    Prints the contents of lst in groups of size step

    Parameter lst: The list to process
    Precondition: lst is a list

    Parameter step:  The number of elements to print at a time
    Precondition: step is an int > 0
    """
    pass # IMPLEMENT ME
