"""
A test script to test our generators

Author: Walker M. White
Date: November 30, 2020
"""
import harm2
import chain
import introcs

def test_harmonic():
    """
    Tests the generator harmonic
    """
    print('Testing harmonic')

    # FIRST TEST
    g = harm2.harmonic(3)

    # Check each element generated
    result = next(g)
    introcs.assert_floats_equal(1.0,result)

    result = next(g)
    introcs.assert_floats_equal(1.5,result)

    result = next(g)
    introcs.assert_floats_equal(1.8333333333,result)

    # Make sure we stop in the right spot
    # Assert error tests to see if we crash with CORRECT error
    introcs.assert_error(next,g,error=StopIteration)

    # SECOND TEST
    g = harm2.harmonic(4)

    # Check each element generated
    result = next(g)
    introcs.assert_floats_equal(1.0,result)

    result = next(g)
    introcs.assert_floats_equal(1.5,result)

    result = next(g)
    introcs.assert_floats_equal(1.833333333,result)

    result = next(g)
    introcs.assert_floats_equal(2.083333333,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)


def test_sumfold():
    """
    Tests the generator sumfold
    """
    print('Testing sumfold')

    # FIRST TEST
    g = chain.sumfold(range(4))

    # Check each element generated
    result = next(g)
    introcs.assert_equals(0,result)

    result = next(g)
    introcs.assert_equals(1,result)

    result = next(g)
    introcs.assert_equals(3,result)

    result = next(g)
    introcs.assert_equals(6,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)

    # SECOND TEST
    g = chain.sumfold([-1,3,7,-5])

    # Check each element generated
    result = next(g)
    introcs.assert_equals(-1,result)

    result = next(g)
    introcs.assert_equals(2,result)

    result = next(g)
    introcs.assert_equals(9,result)

    result = next(g)
    introcs.assert_equals(4,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)


def test_filterdiv():
    """
    Tests the generator filterdiv
    """
    print('Testing filterdiv')

    # FIRST TEST
    g = chain.filterdiv(range(5),2)

    # Check each element generated
    result = next(g)
    introcs.assert_equals(0,result)

    result = next(g)
    introcs.assert_equals(2,result)

    result = next(g)
    introcs.assert_equals(4,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)

    # SECOND TEST
    g = chain.filterdiv(range(5),3)

    # Check each element generated
    result = next(g)
    introcs.assert_equals(0,result)

    result = next(g)
    introcs.assert_equals(3,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)

    # THIRD TEST
    g = chain.filterdiv([5,-1,3,10,-5],5)

    # Check each element generated
    result = next(g)
    introcs.assert_equals(5,result)

    result = next(g)
    introcs.assert_equals(10,result)

    result = next(g)
    introcs.assert_equals(-5,result)

    # Make sure we stop in the right spot
    introcs.assert_error(next,g,error=StopIteration)


# Script Code
if __name__ == '__main__':
    test_harmonic()
    test_sumfold()
    test_filterdiv()
    print('The generators passed all tests')
