"""
Module showing off how to move an image with arrow keys.

This is a completed module. We will leverage it in the composite demo, where we have
to write the code from scratch.

Author: Walker M. White
Date: November 30, 2020
"""
from game2d import *


### Constants ###

# The initial window width
GAME_WIDTH  = 640
# The initial window height
GAME_HEIGHT = 480

# Pixels to move the image each frame
IMAGE_STEP = 10
# The width of the image
IMAGE_WIDTH  = 100
# The height of the image
IMAGE_HEIGHT = 100

class App(GameApp):
    """
    The basic app for moving an image with arrow keys

    The image moves so long as the arrow keys are held down. So we do not need to
    distinguish between presses and releases
    """
    # Attribute _image: The image to move
    # Invariant: _image is a GImage object

    def start(self):
        """
        Initialize the image
        """
        self._image = GImage(source='go.png',width=IMAGE_WIDTH,height=IMAGE_HEIGHT)
        self._image.x = self.width//2
        self._image.y = self.height//2

    def update(self,dt):
        """
        Move the image about the screen

        Parameter dt: The time since the last animation frame
        Precondition: dt is a float
        """

        # Do NOT use elifs.
        # This way we can move diagonally holding down more than one key
        if self.input.is_key_down('up'):
            self._image.y = self._image.y + IMAGE_STEP
        if self.input.is_key_down('down'):
            self._image.y = self._image.y - IMAGE_STEP
        if self.input.is_key_down('left'):
            self._image.x = self._image.x - IMAGE_STEP
        if self.input.is_key_down('right'):
            self._image.x = self._image.x + IMAGE_STEP

    def draw(self):
        """
        Draw the image
        """
        self._image.draw(self.view)


# Script Code
if __name__ == '__main__':
    App(width=GAME_WIDTH,height=GAME_HEIGHT).run()
