"""
Module using generators for the harmonic series

We do not expect you to have the calculus to understand the significance of these.
We are just using this generator and function for looking at call frames.

In this modification of harm1, we replace harmonic with a generator.

Author: Walker M. White
Date: November 30, 2020
"""


def rnginv(n):
    """
    Generates the inverse range 1, 1/2, 1/3, .... 1/(n-1)

    Parameter n: The range bounds
    Precondition: n is an int > 0
    """
    for x in range(1,n):
        yield 1/x


def harmonic(n):
    """
    Generates the partial sums of the harmonic series up 1/n

    The partial sum for k is 1+1/2+1/3+...+1/k

    Parameter n: The range bounds
    Precondition: n is an int > 0
    """
    pass # Implement me
    sum = 0
    for x in rnginv(n+1):
        sum = sum+x
        yield sum
