"""
Module using generators for the harmonic series

We do not expect you to have the calculus to understand the significance of these.
We are just using this generator and function for looking at call frames

Author: Walker M. White
Date: November 30, 2020
"""


def rnginv(n):
    """
    Generates the inverse range 1, 1/2, 1/3, .... 1/(n-1)

    Parameter n: The range bounds
    Precondition: n is an int > 0
    """
    for x in range(1,n):
        yield (1/x)


def harmonic(n):
    """
    Computes the partial sum of the harmonic series to 1/(n-1)

    The sum is 1+1/2+1/3+...+1/(n-1)

    Parameter n: The range bounds
    Precondition: n is an int > 0
    """
    sum = 0
    g = rnginv(n)
    for x in g:
        sum = sum+x
    return sum
