"""
A module containing a class for a license plate.

This class is a slightly modified version of the one in the
2018 Prelim 2

Author: Walker M. White
Date: November 1, 2020
"""


class License(object):
    """
    A class representing a license plate.

    Each license must be unique (guaranteed by the CLASS
    attribute). A license may or may not have and assigned
    ower

    CLASS ATTRIBUTES (NO GETTERS/SETTERS):
       Attribute USED:  The license plates used so far (initially empty)
       Invariant: USED is a list of (prefix,suffix) pairs
    """
    # MUTABLE ATTRIBUTES:
    # Attribute _owner: The name of the owner
    # Invariant: _owner is a nonempty string or None
    #
    # IMMUTABLE ATTRIBUTES:
    # Attribute _prefix: The first half of the licence
    # Invariant: _prefix is a str of 3 upper case letters
    #
    # Attribute _suffix: The second half of the licence
    # Invariant: _suffix is an int in 0..9999 inclusive

    # GETTERS AND SETTERS GO HERE

    # INITIALIZER
    def __init__(self, prefix, suffix, owner=None): # Fill in missing part
        """
        Initializes a license plate with the given prefix
        and suffix.

        No license plate can be created if it has the same
        prefix and suffix as an existing plate (this will
        cause an AssertionError). On creation, the pair
        (prefix,suffix) is added to the class attribute USED
        to ensure that they cannot be reused.

        Parameter prefix: The first half of the licence
        Precondition: prefix is a string of 3 upper case letters

        Parameter suffix: The second half of the licence
        Precondition: suffix is an int in 0..9999, inclusive

        Parameter owner: The name of the owner (Optional; default None)
        Precondition: owner is a nonempty string or None

        Additional precondition: No other license plate has
        this prefix,suffix
        """
        pass #IMPLEMENT ME


    def __str__(self):
        """
        Returns a string representation of this license plate.

        The string is of the form prefix-suffix. The suffix
        is padded with leading 0s to have three characters.
        If the plate has an owner, the owner follows the
        string in parentheses. Otherwise, nothing is added
        to the string.

        Example: 'ABC-001' if no owner, or 'XYZ-093 (Bob)'
        """
        pass #IMPLEMENT ME
