"""
A module to demonstrate the difference between print and return

The command print displays a value on screen, but it does not use that value
when it evaluates the function.  The command return instructs a function call
to evaluate to that value.

Author: Walker M. White
Date:   August 31, 2017 (Python 3 Version)
"""

def print_plus(n):
    """
    Prints the value of n+1 to the screen.
    
    This function does not return anything, so a function call does not
    evaluate to anything: it is a procedure.
    
    Parameter n: The number to add to
    Precondition: n is a number
    """
    print(n+1)


def return_plus(n):
    """
    Returns: the value of n+1 to the screen.
    
    This function is a fruitful function and can be used in expressions.
    However, it does not necessarily display anything on screen.
    
    Parameter n: The number to add to
    Precondition: n is a number
    """
    return (n+1)
