# lab08for_test.py
# Lillian Lee (LJL2) and Walker White (wmw2)
# March 15, 2017

"""Test code for lab."""

import lab08for
import cornelltest as ct
import inspect  # Used to get function names automatically.
                # inspect.stack()[0] is the "highest" frame on the call stack


def test_lesser_than():
    """Test lesser_than"""
    fn_name = inspect.stack()[0][3] # get name from its frame on the stack!
    print "Running " + fn_name


    # Use dictionaries and loops to make writing test cases less tedious.
    # Technicality: dictionary keys must be "hashable", so can't use lists;
    #   hence, using tuples instead.
    test_cases = {((5, 9, 1, 7), 4): 1,
                  ((5, 9, 1, 7), 5): 1,
                  ((5, 9, 1, 7), 8): 3,
                  ((), -2): 0,
                  ((), 2): 0,
                  ((4, 5, 6), 1): 0,
                  ((4, 5, 6), 7): 3,
                  ((4, 4, 4), 7): 3
    }

    for item in test_cases:
        orig = list(item[0])
        argslist = [orig, item[1]]
        seq = orig[:]   # this creates a copy of the list orig
        print "\tTesting input " + str(argslist)

        # The star operator unpacks a list of arguments into the arguments for
        # a function. Which is pretty cool.  Otherwise, we'd have to write
        # lab08for.clamp(orig, item[1]).
        output = lab08for.lesser_than(*argslist)
        ct.assert_equals(test_cases[item], output)
        ct.assert_equals(seq, orig) # make sure argument list wasn't changed


def test_uniques():
    """Test uniques"""
    fn_name = inspect.stack()[0][3]
    print "Running " + fn_name

    # For keys, use tuples,  because immutable, instead of lists, which are mutable
    test_cases = {
        (1,3,5): 3,
        (5,1,3,5,3,5,5,5): 3,
        (13, "hola", 'b', 7, 'hola', 2): 5,
        (1, 1, 1, 1): 1,
        ():0,
    }

    for item in test_cases:
        orig = list(item)
        seq = orig[:]
        print "\tTesting input" + str(list(seq))
        output = lab08for.uniques(seq)
        ct.assert_equals(test_cases[item], output)
        error_msg = "original list " + str(orig) + " was changed to " + str(seq)
        assert (seq == orig), error_msg


def test_clamp():
    """Test clamp"""
    fn_name = inspect.stack()[0][3]
    print "Running " + fn_name

    test_cases = {
        ((4, -1, 1, 6, 3), 0, 5): [4, 0, 1, 5, 3],
        ((17, -1, 2, 27, 14), 2, 3): [3, 2, 2, 3, 3],
        ((17, -1, 2, 27, 14), 2, 2): [2, 2, 2, 2, 2],
        ((5.3, 0, 2, 8.5, 4), 0, 8): [5.3, 0, 2, 8, 4],
        ((), 2, 3): [],
    }

    for item in test_cases:
        inlist = list(item[0]) # Need to convert tuple to list
        argslist = [inlist, item[1], item[2]]
        print "\tTesting input " + str(argslist)

        # The star operator unpacks a list of arguments into the arguments for
        # a function. Which is pretty cool.  Otherwise, we'd have to write
        # lab08for.clamp(inlist, item[1], item[2])
        lab08for.clamp(*argslist)
        ct.assert_equals(test_cases[item], inlist)

test_lesser_than()
test_uniques()
test_clamp()

print "All tests passed"


