# cardstufftest.py
# Lillian Lee (LJL2) and Steve Marschner (SRM2)
# Mar 5, 2017

"""Module for testing some functions in card"""

import cornelltest
import cardstuff
import sys, StringIO # for testing printout.  http://stackoverflow.com/questions/2654834/capturing-stdout-within-the-same-process-in-python/3113913#3113913



def test_draw():
    """Quick diagnostic test of whether draw seems to be working.
    May depend on equality being correct for cards"""
    print "Testing test_draw"
    clist = [cardstuff.Card(1,11)]
    hand = [cardstuff.Card(2,3)]
    # Have a hand containing the 3 of hearts, drawing from a 'deck' 
    # containing just the Jack of Diamonds
   
    hand.append(cardstuff.draw(clist))

    cornelltest.assert_equals(0,len(clist))
    cornelltest.assert_equals(2,len(hand))
    cornelltest.assert_true(cardstuff.Card(2,3) in hand)
    cornelltest.assert_true(cardstuff.Card(1,11) in hand)

    # Now trying to draw from a full deck, checking lengths.
    clist = cardstuff.full_deck()
    hand.append(cardstuff.draw(clist))
    cornelltest.assert_equals(51, len(clist))
    cornelltest.assert_equals(3,len(hand))

    print "finished test of test_draw()"


def test_compare():
    """Test cardstuff.poker_compare"""
    print "Running test_compare"

    # we don't guarantee that this is a thorough set of test cases
    cornelltest.assert_equals(-1, cardstuff.poker_compare(cardstuff.Card(2,10),cardstuff.Card(2,11)))
    cornelltest.assert_equals(-1, cardstuff.poker_compare(cardstuff.Card(3,10),cardstuff.Card(2,11)))
    cornelltest.assert_equals(1,  cardstuff.poker_compare(cardstuff.Card(2,13),cardstuff.Card(2,11)))
    cornelltest.assert_equals(1,  cardstuff.poker_compare(cardstuff.Card(3,10),cardstuff.Card(2,1)))
    cornelltest.assert_equals(0,  cardstuff.poker_compare(cardstuff.Card(3,10),cardstuff.Card(3,10)))
    cornelltest.assert_equals(-1, cardstuff.poker_compare(cardstuff.Card(3,2), cardstuff.Card(2,3)))

    print "finished test_compare"



def test_draw_poker_hand():

    fd = cardstuff.full_deck()
    hand = cardstuff.draw_poker_hand(fd)
    print 'Drawing a poker hand. It is:\n',
    cardstuff.print_cards(hand)

    # check that we got five cards
    cornelltest.assert_equals(5, len(hand))

    # check that 5 cards were removed from the deck
    cornelltest.assert_equals(52-5, len(fd))

    # check that none of the cards in the hand are in the deck
    for c in hand:
        cornelltest.assert_true(not c in fd)

    # check that the cards in the hand are all different
    for cindex in range(5):
        for compareindex in range(cindex+1,5):
            cornelltest.assert_false(hand[cindex] == hand[compareindex])

    print ("\nfinished test of draw_poker_hand")






test_draw()
test_compare()
test_draw_poker_hand()
print 'All test cases for cardstuff passed'


