# cardstuff.py
# YOUR NAME AND NETID HERE;
# PUT THE DATE HERE
# skeleton by Lillian Lee (LJL2) and Steve Marschner (SRM2), Mar 5, 2017


"""Module providing a type for playing cards

Implementation adapted from chapter 18 of the course text, _Think Python_,
by Allen B. Downey.
"""
import random

# It may be a bit unconventional to have these be global variables rather
# than what are known as class variables, but this may be more readable to
# the beginning student.

SUIT_NAMES = ['Clubs', 'Diamonds', 'Hearts', 'Spades']
NUM_SUITS = len(SUIT_NAMES) # number of suits

# The item at index 0 is None so that we can treat RANK_NAMES as a translation
# table: RANK_NAME[1] is 'Ace', RANK_NAME[13] is 'King', etc.
RANK_NAMES = [None, 'Ace', '2', '3', '4', '5', '6', '7',
      '8', '9', '10', 'Jack', 'Queen', 'King']
NUM_RANKS=13 # number of ranks


class Card(object):
    """An instance is a standard playing card.

    Instance variables:
        suit [int in 0..NUM_SUITS-1]: this card's suit is SUIT_NAMES[suit]

        rank [int in 1..NUM_RANKS]: this card's rank is RANK_NAMES[rank]
    """

    def __init__(self, s, r):
        """Initializer: A new Card whose suit is s and rank is r

        Note that suits and ranks are stored as ints.  For example,
        an Ace is rank 1, a 10 is rank 10, a King is rank 13 (there's no rank 0);
        a Club is suit 0, a spade is suit 3.

        Hence, if we execute c = Card(0, 12), SUIT_NAMES[c.suit] is 'Clubs'
        and RANK_NAMES[c.rank] is '12'.

        Preconditions: s in 0..NUM_SUITS-1 (inclusive) and
        r in 1..NUM_RANKS (inclusive)"""
        self.suit = s
        self.rank = r

    def __str__(self):
        """Readable string representation of this card.
        Example: '2 of Hearts'"""
        return RANK_NAMES[self.rank] + ' of ' + SUIT_NAMES[self.suit]

    def __eq__(self, other):
        """Equality determined by equality of attributes"""
        return (isinstance(other,Card) and
            (self.suit, self.rank) == (other.suit, other.rank))

    def __ne__(self, other):
        """Non-equality determined opposite of equality"""
        return not self.__eq__(other)

    def __cmp__(self, other):
        """Poker order (as opposed to bridge order).

        Returns:
          -1 if self's rank is less than other's rank or self and other's
            rank are the same but self has lower suit
          0 if self and other's rank and self are the same
          1 otherwise.

        Precondition: other is a Card."""
        return poker_compare(self, other)


def full_deck():
    """Returns: list of the standard 52 cards"""
    output = []  # list of cards so far to be returned
    for suit in range(NUM_SUITS):
        # range(n) creates the list [0,1,2,...,n-1]
        for rank in range(1,NUM_RANKS+1):
            # range(1,n) creates the list [1,2,...,n-1]
            # skip the None value
            output.append(Card(suit,rank))
    return output


def print_cards(clist):
    """Print cards in list clist, which is a (possibly empty) list of Cards.."""
    for c in clist:
        print c
        

def draw(deck):
    """Returns: a card that is randomly drawn (and removed) from deck.

    Precondition: deck is a list of cards containing at least one card."""
    i = random.randrange(len(deck)) # random int in 0..len(deck)-1

    # TODO: add a line make this function obey its specification
    # You will, of course, want to use the value of i.
    # This function is used in draw_poker_hand, below.


def poker_compare(c1, c2):
        """Poker ordering (as opposed to bridge ordering) of Cards c1 and c2

          -1 if c1's rank is less than c2's rank,  or c1 and c2's
            rank are the same but c1 has lower suit
          0 if c1 and c2's rank and suit are the same
          1 otherwise.

        Order is determined by position in suit_names or rank_names, respectively.

        Precondition: c1 and c2 are Cards."""
        pass

        # TODO: implement this function according to its specification.
        # it is used in card.__cmp__, which will make draw_poker_hand, next,
        # work nicely



def draw_poker_hand(deck):
    """Returns: list of five cards drawn from deck, in reverse sorted order.

    The cards are removed from deck.  We use reverse sorted order because people
    tend to sort their cards with highest value to the left.

    Precondition: deck is a list of Cards containing at least five Cards."""

    output = []  # An empty list for you to add cards to when you draw them

    # TODO: put in lines so that variable <output> eventually holds what we want to return.
    #
    # Syntax hint: If clist is a list of Cards, then clist.sort() will use your
    # poker_compare() function to put the list in poker-sorted order.
    #
    # Syntax hint: since we're inside the file cardstuff.py, you say draw(deck)
    # instead of cardstuff.draw(deck)


    return output



