# lab05_accessories.py
# Lillian Lee (LJL2) and Walker White (WMW2)
# Feb 2017

"""Accessory functions and definitions for students to use in Lab 05.

Students do not need to edit this file.

"""

import lab05
import cornelltest


####### Time class definition


class Time(object):

    """Instances represent a duration of time in hours and minutes.

    Attributes:
        hours: number of hours [int, must be nonnegative]
        minutes: number of minutes not accounted for in hours [int in the range 0..59]

    """

    ## STUDENTS: don't worry about the syntax of this method definition.
    ## Just know that a call of the form Time(x,y) will set the new Time's
    ## hours to x and the Time's minutes to y.
    def __init__(self, h, m):
        """Sets this Time's hours to h and minutes to m.

        Preconditions: h is a positive int, h is an int in range 0..59"""
        self.hours = h
        self.minutes = m




####### Pig Latin functions


# helper for first_vowel; students do not need to use this directly.
def my_find(letter, s):
    """Returns: position of letter in s, or len(s) if letter not in s.
    Intended use is as a helper for first_vowel.

    Precondition: letter is a lowercase letter
        s is a possibly empty string of lowercase letters."""

    # This function is a workaround for the fact that it would be more
    # convenient for us, in this lab, if str.find returned a big
    # number, like len(s),  when it failed, rather than -1.

    found_result = s.find(letter)
    return (found_result if found_result > -1 else len(s))


# helper for students, who should use it without modification
def first_vowel(w):
    """Returns: position of the first vowel in w, -1 if no vowel,
    where vowels are defined as in the lab handout.

    Precondition: w is a nonempty string with only lowercase letters."""
    
    # best_location is smallest index found so far of a vowel;
    # it has value len(w) if none found yet
    best_location = len(w)
    best_location = min(best_location, my_find('a', w))
    best_location = min(best_location, my_find('e', w))
    best_location = min(best_location, my_find('i', w))
    best_location = min(best_location, my_find('o', w))
    best_location = min(best_location, my_find('u', w))

    # can only count a y if w has at least one letter in it
    if len(w) > 1:
        best_y_location = 1 + my_find('y', w[1:])
        best_location = min(best_location, best_y_location)

    return (best_location if best_location < len(w) else -1)


##### TEST PROCEDURES


def test_add_time():
    print "Running test_add_time"
    t1 = Time(1,59)
    t2 = Time(1,2)
    msg =  '\tTrying '+str(t1.hours)+":"+str(t1.minutes)
    msg = msg + ' and '+str(t2.hours)+":"+str(t2.minutes)
    print msg
    sum = lab05.add_time(t1,t2)
    cornelltest.assert_equals(3, sum.hours)
    cornelltest.assert_equals(1, sum.minutes)
    
    t1 = Time(1,59)
    t2 = Time(3,59)
    msg =  '\tTrying '+str(t1.hours)+":"+str(t1.minutes)
    msg = msg + ' and '+str(t2.hours)+":"+str(t2.minutes)
    print msg
    sum = lab05.add_time(t1,t2)
    cornelltest.assert_equals(5, sum.hours)
    cornelltest.assert_equals(58, sum.minutes)
    
    t1 = Time(1,50)
    t2 = Time(0,2)
    msg =  '\tTrying '+str(t1.hours)+":"+str(t1.minutes)
    msg = msg + ' and '+str(t2.hours)+":"+str(t2.minutes)
    print msg
    sum = lab05.add_time(t1,t2)
    cornelltest.assert_equals(1, sum.hours)
    cornelltest.assert_equals(52, sum.minutes)
    
    print "Tests of test_add_time completed"


def test_pigify():
    print "Running test_pigify to test lab05.pigify"

    ## STUDENTS:
    ## At this point in the class, you do not know what dictionaries are.
    ## But for the curious: test_cases is a structure that lets you organize
    ## pairs of a so-called "key" (the first item in a pair) and an associated
    ## "value" (the second item in a pair).
    ## In our case, the keys and values are inputs and desired outputs.

    # These test cases come from the lab handout.
    test_cases = {'ask': 'askhay',
                  'use': 'usehay',
                  'quiet': 'ietquay',
                  'quay': 'ayquay',
                  'tomato': 'omatotay',
                  'school': 'oolschay',
                  'you': 'ouyay',
                  'pssst': 'pssstay'
                  }

    ## STUDENTS:  "
    ## At this point in the class, you do not know what for-loops/blocks are.
    ## But for the curious: the code below runs assert_equals on each
    ## input/output pair in the test_cases dictionary
    for w in test_cases:
        print '\tTrying "' + w + '"'
        cornelltest.assert_equals(test_cases[w], lab05.pigify(w))


# SCRIPT CODE

## STUDENTS: this mysterious line makes the code beneath run only if
## this file is NOT being imported, but instead run on the command line
if __name__ == '__main__':
    print "Beginning tests of lab05 code"
    test_add_time()
    test_pigify()
    print "All tests passed"
