# May5.py
""" A version of the numpy function linspace
that works in "base Python" and returns a list
of floats.
"""

from numpy import *

def my_linspace(a,b,n):
    """ Returns a length n list of floats x
    where
    
       a = x[0] < x[1} < ... < x[n-1] = b
       
    and the x[i] are equally spaced.
    
    PreC: a and b are floats with a<b and n is an 
    int whose value is at least 2.
    """
    # The spacing...
    h = (b-a)/(n-1)
    # v is the next value to append to x
    v = a
    x = []
    for i in range(n):
        x.append(v)
        v += h
    return x

if __name__ == '__main__':
    n = 7
    a = 2.0
    b = 5.0
    print '\na = %3.1f \nb = %3.1f  \nn = %1d'% (a,b,n)
    my_x = my_linspace(a,b,n)
    print '\nmy_linspace(a,b,n):'
    print '   ',my_x
    x = linspace(a,b,n)
    print '\nlinspace(a,b,n):'
    print '   ',x
    

    









