# May3.py
""" Keep adding cards to a hand until all four suits
are present.
"""

from numpy import *
from random import uniform as randu

def randuM(m,n,L,U):
    """ Returns an mxn numpy array of random floats
    selected from the interval [L,U]
    
    PreC: m and n are positive ints. L and U are floats
    that  satisfy L<R
    """
    # Use zeros to establish A as an mxn array. Then fill it up
    A = zeros((m,n))
    for i in range(m):
        # Set up row i
        for j in range(n):
            A[i,j] = randu(L,U)
    return A

def Update(P,v):
    """ Returns an n-by-1 array w where 
       w[i] = P[i,0]*v[0] + P[i,1]*v[1] + ... P[i,n-1]*v[n-1]
    for i = 0,1,....,n-1
    
    PreC: P is an n-by-n numpy array and v is an n-by-1
    numpy array
    """
    n = len(v)
    w = zeros((n,1))
    for i in range(n):
        for j in range(n):
            w[i] += P[i,j]*v[j]
    return w

def MyUpdate(P,v):
    """ Returns an n-by-1 array w where 
       w[i] = P[i,0]*v[0] + P[i,1]*v[1] + ... P[i,n-1]*v[n-1]
    for i = 0,1,....,n-1
    
    PreC: P is an n-by-n numpy array with P[i,j]=0 whenever
    abs(i-j)>1.
    v is an n-by-1 numpy array.
    """
    n = len(v)
    w = zeros((n,1))
    for i in range(n):
        if i==0:
            w[i] = P[i,i]*v[i] + P[i,i+1]*v[i+1]
        elif i==n-1:
            w[i] = P[i,i-1]*v[i-1] + P[i,i]*v[i] 
        else:
            w[i] = P[i,i-1]*v[i-1] + P[i,i]*v[i] + P[i,i+1]*v[i+1]
    return w

if __name__ == '__main__':
    
    # Generate an example...
    n = 6
    v = randuM(n,1,0,1)
    A = randuM(n,n,0,1)
    for i in range(n):
        for j in range(n):
            if abs(i-j)>1:
                A[i,j] = 0
    
    # Compute the update two ways...
    print 'Update(A,v):'
    wUpdate = Update(A,v)
    print wUpdate
    
    print '\nMyUpdate(A,v):'
    wMyUpdate = MyUpdate(A,v)
    print wMyUpdate
    





