#ShowMedian.py
""" Shows how to compute the median value in a 2-dim
array.
"""

from numpy import *
from random import randint as randi


def TwoD_Median(A):
    """ Returns the median of the values in A
    
    PreC: A is a 2-dim numpy array of floats.
    """
    (m,n) = A.shape
    # Compute the number of entries in A
    N = m*n
    v = zeros(m*n)
    # Assemble all the values in A in a 1-dimensional array
    k = 0;
    for i in range(m):
        for j in range(n):
            v[k] = A[i,j]
            k+=1
    # Sort the values and pick the "middle" number
    v.sort()
    N = m*n
    if N%2==1:
        # The median is the middle value
        return v[N/2]
    else:
        # The median is the average of the two values that
        # "straddle"" the middle.
        return ((v[N/2]+v[N/2-1])/2)

if __name__ == '__main__':
    """ A small 3x3 example.
    """
    A = zeros((3,3))
    print '\n A = '
    for k in range(3):
        A[k,0] = float(randi(10,99))
        A[k,1] = float(randi(10,99))
        A[k,2] = float(randi(10,99))
        print '      %2d  %2d  %2d' % (A[k,0],A[k,1],A[k,2])
        
    m  = TwoD_Median(A)
    print '\nThe median value is %2d' %  m
    



