#ChaosOrder.py
""" A random polygon when repeatedly "averaged"
untangles itsself.
"""

from numpy import *
from pylab import *
from random import uniform as randu

class polygon:
    def __init__(self,x,y):
        """ The vertices of the polygon are
        (x[0],y[0]),...,([x[n-1],y[n-1])])
        PreC: x and y are length-n numpy arrays of floats
        """
        self.x = x
        self.y = y
    
    def newPoly(self):
        """ Modifies self so that it represents
        the polygon whose vertices are the side midpoints
        of self.
        """
        n = len(self.x)
        x = zeros(n)
        y = zeros(n)
        for k in range(n):
            x[k] = (self.x[k]+self.x[(k+1)%n])/2
            y[k] = (self.y[k]+self.y[(k+1)%n])/2
        self.x = x
        self.y = y
    
    def plotPoly(self):
        """ Displays the polygon self.
        """
        x = self.x;y = self.y
        n = len(x)
        x0 = zeros(n+1); y0 = zeros(n+1)
        for k in range(n):
            x0[k]= x[k]; y0[k] = y[k]
        x0[n] = x[0]; y0[n] = y[0]
        #plot(x0,y0)
        plot(x0,y0,marker='o')
        m = 1.1*max(max(abs(x)),max(abs(y)))
        xlim(-m,m); ylim(-m,m)
    
if __name__ == '__main__':
    # Generate a random polygon with centroid (0,0)
    n = 30
    x = zeros(n); y = zeros(n)
    for k in range(n):
        x[k] = randu(-1,1); y[k] = randu(-1,1)
    x = x-sum(x)/n; y = y - sum(y)/n
    P = polygon(x,y)

    # Repeatedly "average" this polygon N times
    N = 100
    for k in range(N+1):
        # Generate and display the next polygon
        P.newPoly()
        figure(0,(8,8))
        hold(False)
        P.plotPoly()
        title('After %1d Iterations' % k)
        xticks([],[]); yticks([],[])
        if k <N:
           show(block=False)
           pause(.001)
        else:
            show()
    
            
        
    
        
        
        
            