#!/usr/bin/env python

from copy import deepcopy
from math import sqrt

def smallDivisors(p,d):
    """
    Returns the index k that maximizes
               p[k]/d[k]
    where k in range(n)
    
    PreC: p and d are length-n lists of ints and every
    entry in d is positive.
    """
    n = len(p)
    m = 0
    for j in range(n):
        q = float(p[j])/d[j]
        if q>m:
            m = q
            k = j
    return k

def largeDivisors(p,d):
    """
    Returns the index k that maximizes
               p[k]/(d[k]+1)
    where k in range(n)
    
    PreC: p and d are length-n lists of ints and every
    entry in d is positive.
    """
    n = len(p)
    m = 0
    for j in range(n):
        q = float(p[j])/(d[j]+1)
        if q>m:
            m = q
            k = j
    return k

def majorFractions(p,d):
    """
    Returns the index k that maximizes
               p[k]/d[k]
    where k in range(n)
    
    PreC: p and d are length-n lists of ints and every
    entry in d is positive.
    """
    n = len(p)
    m = 0
    for j in range(n):
        q1 = float(p[j])/d[j]
        q2 = float(p[j])/(d[j]+1)
        q = (q1+q2)/2
        if q>m:
            m = q
            k = j
    return k

def equalProportions(p,d):
    """
    Returns the index k that maximizes
               p[k]/d[k]
    where k in range(n)
    
    PreC: p and d are length-n lists of ints and every
    entry in d is positive.
    """
    n = len(p)
    m = 0
    for j in range(n):
        q1 = float(p[j])/d[j]
        q2 = float(p[j])/(d[j]+1)
        q = sqrt(q1*q2)
        if q>m:
            m = q
            k = j
    return k

        
        

if __name__ == '__main__':  
    # Acquire 2010 census data  
    FileName = 'StatePop.dat'
    f = file(FileName, 'r')
    state = []
    p = []
    for line in f:
        x = line.split()
        if len(x)>0:
            state.append(x[0])
            p.append(int(x[1])) 
    f.close()

    numDistricts = 435
    
    
    # Small Divisors Method
    d = []
    N = numDistricts
    for k in range(50):
        d.append(1)
        N = N - 1
    while N>0:
        k = smallDivisors(p,d)
        d[k]+=1
        N = N-1
    dSD = deepcopy(d)
    
    # Large Divisors Method
    d = []
    N = numDistricts
    for k in range(50):
        d.append(1)
        N = N - 1
    while N>0:
        k = largeDivisors(p,d)
        d[k]+=1
        N = N-1
    dLD = deepcopy(d)
    
    # Major Fraction Method
    d = []
    N = numDistricts
    for k in range(50):
        d.append(1)
        N = N - 1
    while N>0:
        k = majorFractions(p,d)
        d[k]+=1
        N = N-1
    dMF = deepcopy(d)
    
    # Equal Proportions Method
    d = []
    N = numDistricts
    for k in range(50):
        d.append(1)
        N = N - 1
    while N>=0:
        k = equalProportions(p,d)
        if N>=2:
            d[k]+=1
            N = N-1
        elif N==1:
            # Assign to Lucky the index of the state that gets district 435
            d[k]+=1
            N = N-1
            Lucky = k
        else:
            # Assign to Unlucky the index of the state that would get district 436
            Unlucky = k
            N = N-1
    dEP = deepcopy(d)
    
    
    # Output Results
    print '         State     Population   SD  LD  MF  EP'
    print '-------------------------------------------------'
    for k in range(50):
        print '%16s  %10d    %2d  %2d  %2d  %2d' % (state[k],p[k],dSD[k],dLD[k],dMF[k],dEP[k])
        
  
    # Some follow up computations associate with the method of equal proportions.
    p1 = float(p[Lucky])
    d1 = d[Lucky]
    p2 = float(p[Unlucky])
    d2 = d[Unlucky]
    delta = sqrt(float(d1*(d1-1))/float(d2*(d2+1)))
    migrate = (p1-delta*p2)/(1 + delta)
    print '\nMethod of Equal Proportions Facts:\n'
    print '         Awarded district 435:  %s' % state[Lucky]
    print 'Would be awarded district 436:  %s' % state[Unlucky]
    print '\nTo change who gets the 435th district, just move %1d people'% migrate
    print 'from %s to %s' % (state[Lucky],state[Unlucky])
    
 
    



