#!/usr/bin/env python

from Card import *
from Deck import *
from Hand import *

def isFullHouse(H):
    """ Returns Trues if H represents a full house,
    i.e., 2 cards at one rank, and three cards with
    some other rank.
    
    PreC: H is a Hand
    """
    # Set up a list of the Card ranks
    H.sort()  # sorts the Cards based on rank
    r = []
    for C in H.cards:
        r.append(C.rank)
    B1 = r[0]==r[1] and r[1]==r[2] and r[3]==r[4]
    B2 = r[0]==r[1] and r[2]==r[3] and r[3]==r[4]
    return (B1 or B2)

def isTwoPair(H):
    """ Returns Trues if H has two pair.
    
    PreC: H is a Hand
    """
    # Set up a list of the Card ranks
    H.sort()  # sorts the Cards based on rank
    r = []
    for C in H.cards:
        r.append(C.rank)
    B1 = r[0]==r[1] and r[2]==r[3] and r[4]!=r[0] and r[4]!=r[2]
    
    B2 = r[0]==r[1] and r[3]==r[4] and r[2]!=r[0] and r[4]!=r[2]
    
    B3 = r[1]==r[2] and r[3]==r[4] and r[0]!=r[1] and r[0]!=r[3]
    
    return (B1 or B2 or B3)


def randomPokerHand():
    D = Deck()
    D.shuffle()
    H = Hand('')
    for j in range(5):
        H.add_card(D.pop_card())
    return H

        

if __name__ == '__main__':
    
    count = 0
    N = 10000
    for k in range(N):
        H = randomPokerHand()
        if isTwoPair(H):
            count+=1
    
print '%1d Full Houses in %1d hands'%(count,N)
    
    