#Deck.py

from random import shuffle as shuffle
from Card import *
class Deck:
    
    def __init__(self):
        self.cards = []
        for suit in range(4):
            for rank  in range(1,14):
                card = Card(suit,rank)
                self.cards.append(card)
    
    def __str__(self):
        """ Returns a string s such that print s
        nicely displays self,
        """
        s = []
        for card in self.cards:
            s.append(str(card))
        return '\n'.join(s)
    
    def pop_card(self):
        """ Returns a card from self
        PreC: self is a deck with at least one card.
        """
        return self.cards.pop()
    
    def add_card(self,card):
        """ Adds card to the Deck self.
        PreC: card is a Card  and self is a list of Cards.
        """
        self.cards.append(card)
        
    def shuffle(self):
        """Randomly permutes the values in self.cards
        """
        shuffle(self.cards)
        
    def sort(self):
        """ Permutes the values in self.cards so that they
        are sorted with respect to the __cmp__ function.
        """
        self.cards.sort()