import urllib, json
import random
import time
import datetime


def getElectric(building):
    """ returns electric data in the form 
    [current value (kW), rate ($/kWh), hourly value ($/hr)]"""
    return _fetchUtility(building, 'Electric')

def getSteam(building):
    """ returns steam data in the form 
    [current value (Lbs/Hour), rate ($/Klbs), hourly value ($/hr)]"""
    return _fetchUtility(building, 'Steam')

def getChilledWater(building):
    """ returns chilled water data in the form 
    [current value (Tons), rate ($/Ton-Hour), hourly value ($/hr)]"""
    return _fetchUtility(building, 'ChilledWater')

def getCost(building):
    (x,a,b) = getElectric(building)
    (y,a,b) = getSteam(building)
    (z,a,b) = getChilledWater(building)
    
    return .08*x++.0265*y+.20*z

# Helper functions


def _buildURL(building, utility):
    # e.g. http://portal.emcs.cornell.edu/GatesHall/Electric?cmd=UTILREAD&random=234
    return "http://portal.emcs.cornell.edu/" + \
        building + "/"+utility+"?cmd=UTILREAD"

def _fetchUtility (building, utility):
    
    # for some reason the first request for data comes up empty sometimes,
    # this will keep trying again every tenth of a second until it finds a result
    data = {'status':[]}
    attempts = 0

    while len(data['status']) == 0 and attempts < 5:
        url = _buildURL(building, utility)
        response = urllib.urlopen(url);
        data = json.loads(response.read())

        if len(data['status']) == 0:
            # trying again
            time.sleep(.1)
            attempts += 1

    # could not find data
    if attempts == 5:
        return None

    # Example result:
    # {
    # "status": [
    #     {
    #         "value": "164.10",
    #         "nodeid": "N20225",
    #         "fn": "text"
    #     },
    #         {
    #         "value": "0.08",
    #         "nodeid": "N20226",
    #         "fn": "text"
    #     },
    #     {
    #         "value": "13.13",
    #         "nodeid": "N20227",
    #         "fn": "text"
    #     }],
    #     "lasttime": 1422490543
    # }


    presentValue = float(data['status'][0]['value'])
    rate         = float(data['status'][1]['value'])
    hourlyValue  = float(data['status'][2]['value'])

    return [presentValue, rate, hourlyValue]

if __name__ == '__main__':
    print getElectric('DuffieldHall')
    print getSteam('DuffieldHall')
    print getChilledWater('DuffieldHall')
    print getCost('DuffieldHall')