#ShowMonthlyBill.py
""" Displays three bar plots that depict the monthly energy costs
for a particular campus building.
"""

from MyEnergy import *
from numpy import *
from pylab import *

print 'Building Names:'
print '     ','Gates         ','Upson          ','Duffield     ','Statler       ','Uris'
print '     ','UrisLibrary   ','GoldwinSmith   ','Sage         ','Rockefeller   ','Bailey \n'    

Building = raw_input('Enter a Building Name:  ')

M = Energy(Building)
(E,S,C) = M.monthlyBill()

figure(figsize=(8,6))

# Display monthly electricity costs.
subplot(3,1,1)
title(Building,fontsize=18)
bar(range(12),E,facecolor='magenta')
c = ['JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC']
xticks([.5,1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5,10.5,11.5],c)
xlim(-.2,12)
ylabel( 'Electric',fontsize=18)

# Display monthly steam costs.
subplot(3,1,2)
bar(range(12),S,facecolor='cyan')
c = ['JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC']
xticks([.5,1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5,10.5,11.5],c)
xlim(-.2,12)
ylabel('Steam',fontsize=18)

# Display monthly chilled water costs.
subplot(3,1,3)
bar(range(12),C,facecolor='blue')
c = ['JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC']
xticks([.5,1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5,10.5,11.5],c)
xlim(-.2,12)
ylabel('Chilled Water',fontsize=18)

show()