#ShowDailyBill.py
""" Displays three plots that depict the daily energy costs
for a particular campus building.
"""


from MyEnergy import *
from numpy import *
from pylab import *

print 'Building Names:'
print '     ','Gates         ','Upson          ','Duffield     ','Statler       ','Uris'
print '     ','UrisLibrary   ','GoldwinSmith   ','Sage         ','Rockefeller   ','Bailey \n'    

Building = raw_input('Enter a Building Name:  ')

M = Energy(Building)
(E,S,C) = M.dailyBill()

figure(figsize=(8,6))

plot(E,label='Electric',linewidth=2)
plot(S,label='Steam',linewidth=2)
plot(C,label='Chilled Water',linewidth = 2)
legend(loc='upper left')

c = ['JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC']
t = [15,45,75,105,135,165,195,225,255,285,315,345]
xticks(t,c)
xlim(0,354)
title(Building,fontsize=18)
ylabel('Cost is Dollars',fontsize=16)

show()