# MyEnergy.py

from numpy import *
from pylab import *

def TimeStamp(day,clock):
    """
    Returns a time stamp string of the form 'dd-MMM-2014-hh-mm'
    PreC: day is a string of the form 'dd-MMM-2014' and
          clock is a string of the form 'hh:mm:ss'
    """
    
    return day + '-' + clock[0:2] + '-' + clock[3:5]

def STdict(TS):
 
    return idxD

class Energy:
    """
    A class for extracting and displaying energy-cost information for a subset of
    Cornell campus buildings.
    
    Attributes:
    
      Name:  a string that is the name of the building
     Image:  a string that specifies the path of the building's jpeg image
    E_rate:  a float that is the cost of electricity per unit of consumption
    S_rate:  a float that is the cost of steam per unit of consumption
    C_rate:  a float that is the cost of chilled water per unit of consumption
         A:  a 35040-by-3 numpy array that houses the 2014 energy snapshots
   TS_list:  a length-35040 list of strings that houses time stamp strings
   TS_dict:  a 35040-item time stamp index dictionary
    """
    
    def __init__(self,BuildingName):
        self.Name = BuildingName
        self.Image = 'BuildingImages/'+BuildingName+'.jpg'
        self.E_rate =  0.02
        self.S_rate =  0.00665
        self.C_rate =  0.05
        
        A = zeros((35040,3))
        TS_list = []
        # Extract electricity consumption data and store in A[:,0]
        # Also form the time stamp list TS_list
        f = file('EnergyData/'+BuildingName+'_E.txt', 'r')
        k = 0
        for line in f:
            if line[0] != '#':
                parts = line.split()
                TS_list.append(TimeStamp(parts[0],parts[1]))
                if parts[2]!='-':
                    # Store the consumption as a float
                    A[k,0] = float(parts[2])
                k+=1
        f.close()
        self.TS_list = TS_list
        
        # Extract steam consumption data and store in A[:,1]
        f = file('EnergyData/'+BuildingName+'_S.txt', 'r')
        k = 0
        for line in f:
            if line[0] != '#':
                parts = line.split()
                if parts[2]!='-':
                    # Store the consumption as a float
                    A[k,1] = float( parts[2])
                k+=1      
        f.close()
        
        # Extract chilled water consumption data and store in A[:,2]
        f = file('EnergyData/'+BuildingName+'_C.txt', 'r')
        k = 0
        for line in f:
            if line[0] != '#':
                parts = line.split()
                if parts[7]!='-':
                    # Store the consumption as a float
                    A[k,2] = float(parts[7])
                k+=1      
        f.close()
        
        self.A = A
        
        # Set up self.TS_dict
        # First, assemble a "standard time" list of timestamps
        
        PreDST_TS   = TS_list[:6440]
        Missing_TS  = ['09-Mar-2014-02-00','09-Mar-2014-02-15','09-Mar-2014-02-30', '09-Mar-2014-02-45']
        DST_TS      = TS_list[6440:29284]
        PostDST_TS  = TS_list[29288:]
        stdTS = PreDST_TS + Missing_TS + DST_TS + PostDST_TS
        # Now make the dictionary
        k=0
        TS_dict = {}
        for t in stdTS:
           TS_dict[t] = k
           k+=1  
        self.TS_dict = TS_dict
        
    def annualBill(self):
        """Returns a tuple (E,S,C) of floats where E is the annual
        cost of electricity, S is the annual cost of steam, and C is
        the annual cost of chilled water.
        """
        E = sum(self.A[:,0])*self.E_rate
        S = sum(self.A[:,1])*self.S_rate
        C = sum(self.A[:,2])*self.C_rate
        return (E,S,C)
    
    def monthlyBill(self):
        """Returns a tuple (E,S,C) of length-12 numpy 1-dim arrays where E[k], S[k],
        and C[k] are is the costs for electricity, steam, and chilled water for the
        k-th month of the year.
        """
        StartIndices = [0,2976,5664,8636,11516,14492,17372,20348,23324,26204,29180,32064]
        EndIndices   = [2975,5663,8635,11515,14491,17371,20347,23323,26203,29179,32063,35039]
        E = zeros((12)); S = zeros(12); C = zeros(12)
        for k in range(12):
            p = StartIndices[k]
            q = EndIndices[k]+1
            E[k] = sum(self.A[p:q,0])
            S[k] = sum(self.A[p:q,1])
            C[k] = sum(self.A[p:q,2])
        E = E*self.E_rate
        S = S*self.S_rate
        C = C*self.C_rate
        return (E,S,C)
    
    def dailyBill(self):
        """Returns a tuple (E,S,C) of length-365 numpy 1-dim arrays where E[k], S[k],
        and C[k] are is the costs for electricity, steam, and chilled water for the
        k-th day of the year.
        """
        E = zeros(365); S = zeros(365); C = zeros(365)
        for k in range(365):
            p = k*96
            q = p+96
            E[k] = sum(self.A[p:q,0])
            S[k] = sum(self.A[p:q,1])
            C[k] = sum(self.A[p:q,2])
        E = E*self.E_rate
        S = S*self.S_rate
        C = C*self.C_rate
        return (E,S,C)
    
    def arbitraryBill(self,T1,T2):
        """ Returns a tuple (E,S,C) of floats that contain costs of electricity,
        steam, and chilled water from the time specified by time stamp T1 through
        the 15-minute period identified by time stamp T2.
        """
        E = 0
        S = 0
        C = 0
        i = 0
        for k in range(self.TS_dict[T1],self.TS_dict[T2]+1):
            E += self.A[k,0]
            S += self.A[k,1]
            C += self.A[k,2]
        return (E*self.E_rate,S*self.S_rate,C*self.C_rate)
    
  
            
        
  
  
    
            
