# EnergyNow.py
""" Displays the current hourly rate of energy consumption
of a given building together with an image of the building.
"""

from MyEnergy import *
from utilities2 import *
from numpy import *
from pylab import *
from simpleGraphicsE import *
import time,datetime

print 'Building Names:'
print '     ','Gates         ','Upson          ','Duffield     ','Statler       ','Uris'
print '     ','GoldwinSmith   ','Sage         ','Rockefeller   ','Bailey \n'    

Building = raw_input('Enter a Building Name:  ')

# Create an Energy object for the building and get the current hourly cost of
# running that building
M = Energy(Building)
D = getCost(Building+'Hall')


# Code to develop the image...

MakeWindow(5,labels=False,bgcolor=WHITE)
# Display the jpeg preserving the 8:6aspect ratio
DrawImage(M.Image,-4,-3,8,6)
# The name of the building at the top of the image
MyText(-.5,4,M.Name,BLACK,24)
# Hourly cost
s = 'Current Hourly Energy Expense = $%1d' % int(D)
MyText(-3,-3.5,s,BLACK,14)
# The date and time of the requested energy snapshot
s = 'Date and Time = %s' % datetime.datetime.now()
MyText(-3,-4.5,s[:32],BLACK,14)
ShowWindow()






