# model.py
# YOUR NAME(S) AND NETID(S) HERE
# DATE COMPLETED HERE
"""Model module for Breakout

This module contains the model classes for the Breakout game. Instances of
Model storee the paddle, ball, and bricks.  The model has methods for resolving
collisions between the various game objects.  A lot of your of your work
on this assignment will be in this class.

This module also has an additional class for the ball.  You may wish to add
more classes (such as a Brick class) to add new features to the game.  What
you add is up to you."""
from constants import *
from game2d import *
import random # To randomly generate the ball velocity

class Model(object):
    """An instance is a single game of breakout.  The model keeps track of the
    state of the game.  It tracks the location of the ball, paddle, and bricks.
    It determines whether the player has won or lost the game.  
    
    To support the game, it has the following instance attributes:
    
        bricks:  the bricks still remaining 
                  [list of GRectangle, can be empty]
        paddle:  the paddle to play with 
                  [GRectangle, never None]
        ball:    the ball 
                  [Ball, or None if waiting for a serve]
    """
    # As with the controller, any attributes that you add to this class
    # must be documented above, along with their invariants.
    
    # INITIALIZER (TO CREATE PADDLES AND BRICKS)
    
    # ADD ANY ADDITIONAL METHODS (PROPERLY SPECIFIED) HERE


class Ball(GEllipse):
    """Instance is a game ball.
    
    We extend GEllipse because a ball needs attributes for
    velocity. This subclass adds these two attributes.
    
    INSTANCE ATTRIBUTES:
        vx: Velocity in x direction [int or float]
        vy: Velocity in y direction [int or float]
    
    You should add two methods to this class: an initializer to set the
    starting velocity  and a method to "move" the ball. The move method
    should adjust the ball position according to the velocity.
    
    NOTE: The ball does not have to be a GEllipse. It could be an instance
    of GImage (why?). This change is allowed, but then you will have to
    modify the class header up above.
    """
    
    # INITIALIZER TO SET VELOCITY
    
    # METHOD TO MOVE BALL BY PROPER VELOCITY
    
    # ADD MORE METHODS (PROPERLY SPECIFIED) AS NECESSARY


# ADD ANY ADDITIONAL CLASSES HERE