# test_lab05.py
# Walker M. White (WMW2)
# October 7, 2014
"""Unit test for Lab 7"""

import cornelltest
import lab07

def test_unique():
    """Test procedure for function unique"""
    print 'Testing function unique'
    thelist = [5, 9, 5, 7] 
    cornelltest.assert_equals(3,lab07.unique(thelist))
    
    thelist = [5, 5, 1, 'a', 5, 'a']
    cornelltest.assert_equals(3,lab07.unique(thelist))
    
    thelist = [1, 2, 3, 4, 5]
    cornelltest.assert_equals(5,lab07.unique(thelist))

    thelist = []
    cornelltest.assert_equals(0,lab07.unique(thelist))


def test_clamp():
    """Test procedure for function clamp"""
    print 'Testing function clamp'
    
    thelist = [-1, 1, 3, 5]
    lab07.clamp(thelist,0,4)
    # You CAN use assert_equals to compare lists
    # Though we will see a better way in A4
    cornelltest.assert_equals([0,1,3,4],thelist)
    
    thelist = [1, 3]
    lab07.clamp(thelist,0,4)
    cornelltest.assert_equals([1,3],thelist)
    
    thelist = [-1, 1, 3, 5]
    lab07.clamp(thelist,1,1)
    cornelltest.assert_equals([1,1,1,1],thelist)
    
    thelist = []
    lab07.clamp(thelist,0,4)
    cornelltest.assert_equals([],thelist)


def test_invert():
    """Test procedure for function invert"""
    print 'Testing function invert'
    
    thelist = ['a', 'b', 'c']
    # You CAN use assert_equals to compare dictionaries
    # Though we will see a better way in A4
    map = lab07.invert(thelist)
    cornelltest.assert_equals({'a':0,'b':1,'c':2},map)
    
    thelist = [2, 1, 0]
    map = lab07.invert(thelist)
    cornelltest.assert_equals({2:0,1:1,0:2},map)
    
    thelist = []
    map = lab07.invert(thelist)
    cornelltest.assert_equals({},map)


def test_listify():
    """Test procedure for function listify"""
    print 'Testing function listify'
    
    thedict = {'a':3}
    # You CAN use assert_equals to compare dictionaries of lists
    # Though we will see a better way in A4
    map = lab07.listify(thedict)
    cornelltest.assert_equals({'a':[3,4]},map)
    
    thedict = {'a':3, 'b':5, 'c':1}
    map = lab07.listify(thedict)
    cornelltest.assert_equals({'a':[3,4],'b':[5,6],'c':[1,2]},map)
    
    thedict = {0:3, 1:5, 2:1}
    map = lab07.listify(thedict)
    cornelltest.assert_equals({0:[3,4], 1:[5,6], 2:[1,2]},map)
    
    thedict = {}
    map = lab07.listify(thedict)
    cornelltest.assert_equals({},map)


def test_reshape():
    """Test procedure for function reshape"""
    print 'Testing function reshape'
    
    result = lab07.reshape([1,2,3,4],2,2)
    # You CAN use assert_equals to compare 2D lists
    # Though we will see a better way in A4
    cornelltest.assert_equals([[1,2], [3,4]], result)
    
    result = lab07.reshape([1,2,3,4,5,6],3,2)
    cornelltest.assert_equals([[1,2], [3,4], [5,6]], result)
    
    result = lab07.reshape([1,2,3,4,5,6],2,3)
    cornelltest.assert_equals([[1,2,3], [4,5,6]], result)
    
    result = lab07.reshape([1,2,3,4],1,4)
    cornelltest.assert_equals([[1,2,3,4]], result)
    
    result = lab07.reshape([1,2,3,4],4,1)
    cornelltest.assert_equals([[1],[2],[3],[4]], result)


# Script code
if __name__ == '__main__':
    test_unique()
    test_clamp()
    test_invert()
    test_listify()
    test_reshape() # OPTIONAL
    print 'Lab 7 is working correctly'
